/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel.styles;

import com.github.developframework.excel.styles.AbstractItemKey;
import com.github.developframework.excel.styles.CompositeColor;
import com.github.developframework.excel.styles.ItemKey;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;

public class CellStyleKey
implements ItemKey {
    private static final Class<? extends ItemKey>[] ITEM_KEY_CLASSES = new Class[]{AlignmentKey.class, BorderKey.class, ConfigKey.class, DataFormatKey.class, FontKey.class, ForegroundKey.class};
    private final List<ItemKey> itemKeys = new LinkedList<ItemKey>();

    @Override
    public void configureCellStyle(Workbook workbook, CellStyle cellStyle) {
        for (ItemKey itemKey : this.itemKeys) {
            itemKey.configureCellStyle(workbook, cellStyle);
        }
    }

    public String toString() {
        return this.itemKeys.stream().sorted(Comparator.comparing(ik -> ik.getClass().getSimpleName())).map(Object::toString).filter(s -> !s.endsWith("{}")).collect(Collectors.joining(" "));
    }

    public static boolean isCellStyleKey(String key) {
        return key.isEmpty() || key.matches("^(\\s*\\w+\\s*\\{(.+?)*}\\s*)+$");
    }

    public static CellStyleKey parse(String key) {
        CellStyleKey cellStyleKey = new CellStyleKey();
        Map<Class<? extends ItemKey>, Map<String, String>> itemKeyMetadataMap = CellStyleKey.disassembleItemKey(key);
        for (Class<? extends ItemKey> itemKeyClass : ITEM_KEY_CLASSES) {
            Map properties = itemKeyMetadataMap.getOrDefault(itemKeyClass, Collections.emptyMap());
            try {
                cellStyleKey.itemKeys.add(itemKeyClass.getConstructor(Map.class).newInstance(properties));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cellStyleKey;
    }

    private static Map<Class<? extends ItemKey>, Map<String, String>> disassembleItemKey(String key) {
        char[] charArray = key.toCharArray();
        StringBuilder itemKeyNameBuilder = new StringBuilder();
        StringBuilder propertiesBuilder = new StringBuilder();
        HashMap<Class<? extends ItemKey>, Map<String, String>> map = new HashMap<Class<? extends ItemKey>, Map<String, String>>();
        boolean inner = false;
        boolean quote = false;
        Class<? extends ItemKey> itemKeyClass = null;
        block6: for (char c : charArray) {
            switch (c) {
                case '\t': 
                case '\n': 
                case ' ': {
                    if (!quote) continue block6;
                    propertiesBuilder.append(c);
                    continue block6;
                }
                case '\'': {
                    quote = !quote;
                    propertiesBuilder.append(c);
                    continue block6;
                }
                case '{': {
                    if (inner) {
                        throw new IllegalArgumentException("item key is valid");
                    }
                    inner = true;
                    itemKeyClass = CellStyleKey.determineItemKey(itemKeyNameBuilder.toString());
                    itemKeyNameBuilder.setLength(0);
                    continue block6;
                }
                case '}': {
                    if (!inner) {
                        throw new IllegalArgumentException("item key is valid");
                    }
                    inner = false;
                    map.put(itemKeyClass, CellStyleKey.disassembleProperties(propertiesBuilder.toString()));
                    itemKeyClass = null;
                    propertiesBuilder.setLength(0);
                    continue block6;
                }
                default: {
                    if (inner) {
                        propertiesBuilder.append(c);
                        continue block6;
                    }
                    itemKeyNameBuilder.append(c);
                }
            }
        }
        return map;
    }

    private static Map<String, String> disassembleProperties(String properties) {
        String[] parts;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String part : parts = properties.split(";")) {
            if (part.isEmpty()) continue;
            int i = part.indexOf(":");
            if (i == -1) {
                map.put(part, "true");
                continue;
            }
            map.put(part.substring(0, i), StringUtils.strip((String)part.substring(i + 1), (String)"'"));
        }
        return map;
    }

    private static Class<? extends ItemKey> determineItemKey(String itemKeyName) {
        for (Class<? extends ItemKey> itemKeyClass : ITEM_KEY_CLASSES) {
            String[] prefixArray;
            for (String prefix : prefixArray = itemKeyClass.getAnnotation(ItemKeySign.class).value()) {
                if (!itemKeyName.equals(prefix)) continue;
                return itemKeyClass;
            }
        }
        throw new IllegalArgumentException("unknown item key \"" + itemKeyName + "\"");
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface ItemKeySign {
        public String[] value();
    }

    @ItemKeySign(value={"align", "a"})
    protected static class AlignmentKey
    extends AbstractItemKey {
        private HorizontalAlignment horizontalAlignment = HorizontalAlignment.CENTER;
        private VerticalAlignment verticalAlignment = VerticalAlignment.CENTER;

        public AlignmentKey(Map<String, String> properties) {
            super(properties);
            if (properties.containsKey("v")) {
                this.verticalAlignment = VerticalAlignment.valueOf((String)properties.get("v").toUpperCase());
            }
            if (properties.containsKey("vertical")) {
                this.verticalAlignment = VerticalAlignment.valueOf((String)properties.get("vertical").toUpperCase());
            }
            if (properties.containsKey("h")) {
                this.horizontalAlignment = HorizontalAlignment.valueOf((String)properties.get("h").toUpperCase());
            }
            if (properties.containsKey("horizontal")) {
                this.horizontalAlignment = HorizontalAlignment.valueOf((String)properties.get("horizontal").toUpperCase());
            }
        }

        @Override
        public void configureCellStyle(Workbook workbook, CellStyle cellStyle) {
            cellStyle.setAlignment(this.horizontalAlignment);
            cellStyle.setVerticalAlignment(this.verticalAlignment);
        }

        public String toString() {
            LinkedList<CallSite> list = new LinkedList<CallSite>();
            if (this.verticalAlignment != VerticalAlignment.CENTER) {
                list.add((CallSite)((Object)("vertical: " + this.verticalAlignment)));
            }
            if (this.horizontalAlignment != HorizontalAlignment.CENTER) {
                list.add((CallSite)((Object)("horizontal: " + this.horizontalAlignment)));
            }
            return String.format("align {%s}", StringUtils.join(list, (String)"; "));
        }

        public HorizontalAlignment getHorizontalAlignment() {
            return this.horizontalAlignment;
        }

        public VerticalAlignment getVerticalAlignment() {
            return this.verticalAlignment;
        }
    }

    @ItemKeySign(value={"border", "b"})
    protected static class BorderKey
    extends AbstractItemKey {
        private BorderStyle style = BorderStyle.THIN;
        private CompositeColor color;

        public BorderKey(Map<String, String> properties) {
            super(properties);
            if (properties.containsKey("color")) {
                this.color = new CompositeColor(properties.get("color"));
            }
            if (properties.containsKey("style")) {
                this.style = BorderStyle.valueOf((String)properties.get("style").toUpperCase());
            }
        }

        @Override
        public void configureCellStyle(Workbook workbook, CellStyle cellStyle) {
            cellStyle.setBorderTop(this.style);
            cellStyle.setBorderRight(this.style);
            cellStyle.setBorderBottom(this.style);
            cellStyle.setBorderLeft(this.style);
            if (this.color != null) {
                this.color.configureBorderColor(workbook, cellStyle);
            }
        }

        public String toString() {
            LinkedList<CallSite> list = new LinkedList<CallSite>();
            if (this.style != BorderStyle.THIN) {
                list.add((CallSite)((Object)("style: " + this.style)));
            }
            if (this.color != null) {
                list.add((CallSite)((Object)("color: " + this.color)));
            }
            return String.format("border {%s}", StringUtils.join(list, (String)"; "));
        }

        public BorderStyle getStyle() {
            return this.style;
        }

        public CompositeColor getColor() {
            return this.color;
        }
    }

    @ItemKeySign(value={"config", "c"})
    protected static class ConfigKey
    extends AbstractItemKey {
        private boolean wrapText;

        public ConfigKey(Map<String, String> properties) {
            super(properties);
            if (properties.containsKey("wrapText")) {
                this.wrapText = Boolean.parseBoolean(properties.get("wrapText"));
            }
        }

        @Override
        public void configureCellStyle(Workbook workbook, CellStyle cellStyle) {
            cellStyle.setWrapText(this.wrapText);
        }

        public String toString() {
            LinkedList<String> list = new LinkedList<String>();
            if (this.wrapText) {
                list.add("wrapText");
            }
            return String.format("config {%s}", StringUtils.join(list, (String)"; "));
        }

        public boolean isWrapText() {
            return this.wrapText;
        }
    }

    @ItemKeySign(value={"dataFormat", "df"})
    protected static class DataFormatKey
    extends AbstractItemKey {
        private String format = "@";

        public DataFormatKey(Map<String, String> properties) {
            super(properties);
            if (properties.containsKey("format")) {
                this.format = properties.get("format");
            }
        }

        @Override
        public void configureCellStyle(Workbook workbook, CellStyle cellStyle) {
            cellStyle.setDataFormat(workbook.createDataFormat().getFormat(this.format));
        }

        public String toString() {
            LinkedList<CallSite> list = new LinkedList<CallSite>();
            if (!this.format.equals("@")) {
                list.add((CallSite)((Object)("format: '" + this.format + "'")));
            }
            return String.format("dataFormat {%s}", StringUtils.join(list, (String)"; "));
        }

        public String getFormat() {
            return this.format;
        }
    }

    @ItemKeySign(value={"font", "f"})
    protected static class FontKey
    extends AbstractItemKey {
        private short size;
        private CompositeColor color;
        private String family;
        private boolean italic;
        private boolean bold;

        public FontKey(Map<String, String> properties) {
            super(properties);
            if (properties.containsKey("size")) {
                this.size = Short.parseShort(properties.get("size"));
            }
            if (properties.containsKey("color")) {
                this.color = new CompositeColor(properties.get("color"));
            }
            if (properties.containsKey("family")) {
                this.family = properties.get("family");
            }
            if (properties.containsKey("italic")) {
                this.italic = Boolean.parseBoolean(properties.get("italic"));
            }
            if (properties.containsKey("bold")) {
                this.bold = Boolean.parseBoolean(properties.get("bold"));
            }
        }

        @Override
        public void configureCellStyle(Workbook workbook, CellStyle cellStyle) {
            Font font = workbook.createFont();
            if (this.family != null) {
                font.setFontName(this.family);
            }
            if (this.size != 0) {
                font.setFontHeightInPoints(this.size);
            }
            font.setItalic(this.italic);
            font.setBold(this.bold);
            if (this.color != null) {
                this.color.configureFontColor(workbook, font);
            }
            cellStyle.setFont(font);
        }

        public String toString() {
            LinkedList<Object> list = new LinkedList<Object>();
            if (this.size != 0) {
                list.add("size: " + this.size);
            }
            if (this.color != null) {
                list.add("color: " + this.color);
            }
            if (this.family != null) {
                list.add("family: '" + this.family + "'");
            }
            if (this.italic) {
                list.add("italic");
            }
            if (this.bold) {
                list.add("bold");
            }
            return String.format("font {%s}", StringUtils.join(list, (String)"; "));
        }

        public short getSize() {
            return this.size;
        }

        public CompositeColor getColor() {
            return this.color;
        }

        public String getFamily() {
            return this.family;
        }

        public boolean isItalic() {
            return this.italic;
        }

        public boolean isBold() {
            return this.bold;
        }
    }

    @ItemKeySign(value={"foreground", "fg"})
    protected static class ForegroundKey
    extends AbstractItemKey {
        private CompositeColor color;
        private FillPatternType type = FillPatternType.SOLID_FOREGROUND;

        public ForegroundKey(Map<String, String> properties) {
            super(properties);
            if (properties.containsKey("color")) {
                this.color = new CompositeColor(properties.get("color"));
            }
            if (properties.containsKey("type")) {
                this.type = FillPatternType.valueOf((String)properties.get("type").toUpperCase());
            }
        }

        @Override
        public void configureCellStyle(Workbook workbook, CellStyle cellStyle) {
            if (this.color != null) {
                this.color.configureForegroundColor(workbook, cellStyle);
                cellStyle.setFillPattern(this.type);
            }
        }

        public String toString() {
            LinkedList<CallSite> list = new LinkedList<CallSite>();
            if (this.color != null) {
                list.add((CallSite)((Object)("color: " + this.color)));
            }
            if (this.type != FillPatternType.SOLID_FOREGROUND) {
                list.add((CallSite)((Object)("type: " + this.type)));
            }
            return String.format("foreground {%s}", StringUtils.join(list, (String)"; "));
        }

        public CompositeColor getColor() {
            return this.color;
        }

        public FillPatternType getType() {
            return this.type;
        }
    }
}

