/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel.styles;

import com.github.developframework.excel.TableDefinition;
import com.github.developframework.excel.styles.CellStyleKey;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;

public class CellStyleManager {
    private final Workbook workbook;
    private final BiConsumer<Workbook, CellStyle> globalConsumer;
    private final Map<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>();

    public CellStyleManager(Workbook workbook, TableDefinition<?> tableDefinition) {
        this.workbook = workbook;
        this.globalConsumer = tableDefinition.globalCellStylesHandle();
        tableDefinition.customCellStyles(workbook).forEach((key, style) -> this.registerCellStyle(workbook, this.globalConsumer, (String)key, (CellStyle)style));
    }

    private void registerCellStyle(Workbook workbook, BiConsumer<Workbook, CellStyle> globalConsumer, String key, CellStyle cellStyle) {
        if (globalConsumer != null) {
            globalConsumer.accept(workbook, cellStyle);
        }
        this.cellStyleMap.put(key, cellStyle);
    }

    public CellStyle getCellStyle(String key) {
        CellStyle cellStyle = this.cellStyleMap.get(key);
        if (cellStyle == null) {
            if (CellStyleKey.isCellStyleKey(key)) {
                CellStyleKey cellStyleKey = CellStyleKey.parse(key);
                String standardKey = cellStyleKey.toString();
                cellStyle = this.workbook.createCellStyle();
                cellStyleKey.configureCellStyle(this.workbook, cellStyle);
                this.registerCellStyle(this.workbook, this.globalConsumer, standardKey, cellStyle);
                if (!standardKey.equals(key)) {
                    this.cellStyleMap.put(key, cellStyle);
                }
            } else {
                throw new IllegalArgumentException(String.format("\"%s\" is not exists or invalid", key));
            }
        }
        return cellStyle;
    }
}

