/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel.styles;

import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;

public class CompositeColor {
    private final String color;

    public String toString() {
        return this.color;
    }

    protected void configureFontColor(Workbook workbook, Font font) {
        if (font instanceof XSSFFont) {
            if (this.color.startsWith("#")) {
                byte[] rgb = this.parseRGB(this.color);
                ((XSSFFont)font).setColor(new XSSFColor(rgb, (IndexedColorMap)new DefaultIndexedColorMap()));
            } else {
                font.setColor(IndexedColors.valueOf((String)this.color).index);
            }
        } else {
            HSSFColor hssfColor;
            HSSFPalette palette = ((HSSFWorkbook)workbook).getCustomPalette();
            if (this.color.startsWith("#")) {
                byte[] rgb = this.parseRGB(this.color);
                hssfColor = palette.findSimilarColor(rgb[0], rgb[1], rgb[2]);
                if (hssfColor == null) {
                    palette.setColorAtIndex((short)255, rgb[0], rgb[1], rgb[2]);
                    hssfColor = palette.getColor(255);
                }
            } else {
                hssfColor = HSSFColor.HSSFColorPredefined.valueOf((String)this.color).getColor();
            }
            font.setColor(hssfColor.getIndex());
        }
    }

    protected void configureForegroundColor(Workbook workbook, CellStyle cellStyle) {
        if (cellStyle instanceof XSSFCellStyle) {
            if (this.color.startsWith("#")) {
                byte[] rgb = this.parseRGB(this.color);
                ((XSSFCellStyle)cellStyle).setFillForegroundColor(new XSSFColor(rgb, null));
            } else {
                cellStyle.setFillForegroundColor(IndexedColors.valueOf((String)this.color).index);
            }
        } else {
            HSSFColor hssfColor;
            HSSFPalette palette = ((HSSFWorkbook)workbook).getCustomPalette();
            if (this.color.startsWith("#")) {
                byte[] rgb = this.parseRGB(this.color);
                hssfColor = palette.findSimilarColor(rgb[0], rgb[1], rgb[2]);
                if (hssfColor == null) {
                    palette.setColorAtIndex((short)255, rgb[0], rgb[1], rgb[2]);
                    hssfColor = palette.getColor(255);
                }
            } else {
                hssfColor = HSSFColor.HSSFColorPredefined.valueOf((String)this.color).getColor();
            }
            cellStyle.setFillForegroundColor(hssfColor.getIndex());
        }
    }

    protected void configureBorderColor(Workbook workbook, CellStyle cellStyle) {
        if (cellStyle instanceof XSSFCellStyle) {
            if (this.color.startsWith("#")) {
                byte[] rgb = this.parseRGB(this.color);
                XSSFColor color = new XSSFColor(rgb, null);
                ((XSSFCellStyle)cellStyle).setTopBorderColor(color);
                ((XSSFCellStyle)cellStyle).setRightBorderColor(color);
                ((XSSFCellStyle)cellStyle).setBottomBorderColor(color);
                ((XSSFCellStyle)cellStyle).setLeftBorderColor(color);
            } else {
                cellStyle.setFillForegroundColor(IndexedColors.valueOf((String)this.color).index);
            }
        } else {
            HSSFColor hssfColor;
            HSSFPalette palette = ((HSSFWorkbook)workbook).getCustomPalette();
            if (this.color.startsWith("#")) {
                byte[] rgb = this.parseRGB(this.color);
                hssfColor = palette.findSimilarColor(rgb[0], rgb[1], rgb[2]);
                if (hssfColor == null) {
                    palette.setColorAtIndex((short)255, rgb[0], rgb[1], rgb[2]);
                    hssfColor = palette.getColor(255);
                }
            } else {
                hssfColor = HSSFColor.HSSFColorPredefined.valueOf((String)this.color).getColor();
            }
            cellStyle.setTopBorderColor(hssfColor.getIndex());
            cellStyle.setRightBorderColor(hssfColor.getIndex());
            cellStyle.setBottomBorderColor(hssfColor.getIndex());
            cellStyle.setLeftBorderColor(hssfColor.getIndex());
        }
    }

    private byte[] parseRGB(String rgbStr) {
        int rgb = Integer.valueOf(rgbStr.substring(1), 16);
        byte r = (byte)(rgb >> 16);
        byte g = (byte)((rgb & 0xFF00) >> 8);
        byte b = (byte)(rgb & 0xFF);
        return new byte[]{r, g, b};
    }

    public CompositeColor(String color) {
        this.color = color;
    }
}

