/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel.styles;

import com.github.developframework.excel.styles.CellStyleKey;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;

public final class DefaultCellStyles {
    public static final String STYLE_TITLE = "font {size: 16; bold}";
    public static final String STYLE_HEADER = "font {bold}";
    public static final String STYLE_BODY = "";
    public static final String STYLE_BODY_BOLD = "font {bold}";
    public static final String STYLE_BODY_ITALIC = "font {italic}";
    public static final String STYLE_BODY_PERCENT = "dataFormat {format: '0.00%'}";
    public static final String STYLE_BODY_DATETIME = "dataFormat {format: 'yyyy-mm-dd hh:mm:ss'}";
    public static final String STYLE_BODY_DATE = "dataFormat {format: 'yyyy-mm-dd'}";
    public static final String STYLE_BODY_TIME = "dataFormat {format: 'hh:mm:ss'}";
    public static final String STYLE_BODY_NUMBER = "align {horizontal: RIGHT}";
    public static final String STYLE_BODY_NUMBER_2_PRECISION = "align {horizontal: RIGHT} dataFormat {format: '0.00'}";

    public static CellStyle buildByCellStyleKey(Workbook workbook, String key) {
        if (CellStyleKey.isCellStyleKey(key)) {
            CellStyleKey cellStyleKey = CellStyleKey.parse(key);
            CellStyle cellStyle = workbook.createCellStyle();
            cellStyleKey.configureCellStyle(workbook, cellStyle);
            return cellStyle;
        }
        return null;
    }
}

