/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.excel.utils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class ValueConvertUtils {
    public static Object stringConvert(String value, Class<?> targetClass) {
        if (value == null) {
            return null;
        }
        if (targetClass == String.class) {
            return value;
        }
        try {
            if (targetClass == Integer.class || targetClass == Integer.TYPE) {
                return new BigDecimal(value).intValue();
            }
            if (targetClass == Long.class || targetClass == Long.TYPE) {
                return new BigDecimal(value).longValue();
            }
            if (targetClass == BigDecimal.class) {
                return new BigDecimal(value);
            }
            if (targetClass == Short.class || targetClass == Short.TYPE) {
                return Short.parseShort(value);
            }
            if (targetClass == Float.class || targetClass == Float.TYPE) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if (targetClass == Double.class || targetClass == Double.TYPE) {
                return Double.parseDouble(value);
            }
            if (targetClass == Boolean.class || targetClass == Boolean.TYPE) {
                return Boolean.parseBoolean(value);
            }
            if (targetClass == Date.class) {
                return Date.from(LocalDateTime.parse(value, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")).atZone(ZoneId.systemDefault()).toInstant());
            }
            if (targetClass == LocalDateTime.class) {
                return LocalDateTime.parse(value, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            }
            if (targetClass == ZonedDateTime.class) {
                return ZonedDateTime.parse(value, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            }
            if (targetClass == LocalDate.class) {
                return LocalDate.parse(value);
            }
            if (targetClass == LocalTime.class) {
                return LocalTime.parse(value);
            }
            if (targetClass.isEnum()) {
                return Enum.valueOf(targetClass, value);
            }
            return value;
        }
        catch (Exception e) {
            return value;
        }
    }

    public static Object doubleConvert(String value, Class<?> targetClass) {
        if (targetClass == Double.class || targetClass == Double.TYPE) {
            return value;
        }
        if (targetClass == String.class) {
            return value;
        }
        if (targetClass == Integer.class || targetClass == Integer.TYPE) {
            return Integer.parseInt(value);
        }
        if (targetClass == Long.class || targetClass == Long.TYPE) {
            return Long.parseLong(value);
        }
        if (targetClass == Short.class || targetClass == Short.TYPE) {
            return Short.parseShort(value);
        }
        if (targetClass == Float.class || targetClass == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (targetClass == Boolean.class || targetClass == Boolean.TYPE) {
            return Integer.parseInt(value) > 0;
        }
        return value;
    }

    public static Object booleanConvert(boolean value, Class<?> targetClass) {
        if (targetClass == Boolean.class || targetClass == Boolean.TYPE) {
            return value;
        }
        if (targetClass == String.class) {
            return Boolean.toString(value);
        }
        if (targetClass == Integer.class || targetClass == Integer.TYPE) {
            return value ? 1 : 0;
        }
        if (targetClass == Long.class || targetClass == Long.TYPE) {
            return value ? 1L : 0L;
        }
        if (targetClass == Short.class || targetClass == Short.TYPE) {
            return (short)(value ? 1 : 0);
        }
        if (targetClass == Float.class || targetClass == Float.TYPE) {
            return Float.valueOf(value ? 1.0f : 0.0f);
        }
        if (targetClass == Double.class || targetClass == Double.TYPE) {
            return value ? 1.0 : 0.0;
        }
        return value;
    }

    public static Object dateConvert(Date value, Class<?> targetClass) {
        if (targetClass == Date.class) {
            return value;
        }
        if (targetClass == LocalDateTime.class) {
            return LocalDateTime.ofInstant(value.toInstant(), ZoneId.systemDefault());
        }
        if (targetClass == ZonedDateTime.class) {
            return ZonedDateTime.ofInstant(value.toInstant(), ZoneId.systemDefault());
        }
        if (targetClass == LocalDate.class) {
            return LocalDateTime.ofInstant(value.toInstant(), ZoneId.systemDefault()).toLocalDate();
        }
        if (targetClass == LocalTime.class) {
            return LocalDateTime.ofInstant(value.toInstant(), ZoneId.systemDefault()).toLocalTime();
        }
        return value;
    }
}

