/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.developframework.jsonview.core.JsonCreator;
import com.github.developframework.jsonview.core.JsonCreatorImpl;
import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import com.github.developframework.jsonview.core.xml.ConfigurationSource;
import com.github.developframework.jsonview.core.xml.FileConfigurationSource;
import com.github.developframework.jsonview.core.xml.JsonviewConfigurationSaxReader;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class JsonviewFactory {
    private JsonviewConfiguration jsonviewConfiguration;
    private ObjectMapper objectMapper;

    public JsonviewFactory(String ... configs) {
        Objects.requireNonNull(configs);
        HashSet<ConfigurationSource> sources = new HashSet<ConfigurationSource>();
        for (String config : configs) {
            sources.add(new FileConfigurationSource(config));
        }
        JsonviewConfigurationSaxReader reader = new JsonviewConfigurationSaxReader(sources);
        this.jsonviewConfiguration = reader.readConfiguration();
        this.objectMapper = new ObjectMapper();
    }

    public JsonviewFactory(Set<String> configs) {
        Objects.requireNonNull(configs);
        HashSet<ConfigurationSource> sources = new HashSet<ConfigurationSource>();
        for (String config : configs) {
            sources.add(new FileConfigurationSource(config));
        }
        JsonviewConfigurationSaxReader reader = new JsonviewConfigurationSaxReader(sources);
        this.jsonviewConfiguration = reader.readConfiguration();
        this.objectMapper = new ObjectMapper();
    }

    public JsonviewFactory(JsonviewConfiguration jsonviewConfiguration, ObjectMapper objectMapper) {
        Objects.requireNonNull(jsonviewConfiguration);
        this.jsonviewConfiguration = jsonviewConfiguration;
        this.objectMapper = objectMapper;
    }

    public JsonviewFactory(JsonviewConfiguration jsonviewConfiguration) {
        this(jsonviewConfiguration, new ObjectMapper());
    }

    public JsonCreator getJsonCreator() {
        return new JsonCreatorImpl(this.jsonviewConfiguration, this.objectMapper);
    }

    public JsonCreator getJsonCreator(ObjectMapper objectMapper) {
        return new JsonCreatorImpl(this.jsonviewConfiguration, objectMapper);
    }

    public JsonviewConfiguration getJsonviewConfiguration() {
        return this.jsonviewConfiguration;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

