/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.element;

import com.github.developframework.jsonview.core.element.DescribeContentElement;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.core.element.NormalPropertyElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public abstract class ContainerElement
extends DescribeContentElement {
    protected List<Element> childElements = new ArrayList<Element>();
    protected Class<?> clazz;
    protected List<String> ignorePropertyNames = new ArrayList<String>();

    public ContainerElement(String data, String alias) {
        super(data, alias);
    }

    public void addChildElement(Element element) {
        this.childElements.add(element);
    }

    public void addIgnoreProperty(String propertyName) {
        this.ignorePropertyNames.add(propertyName);
    }

    public boolean isIgnore(Field field) {
        return this.ignorePropertyNames.contains(field.getName());
    }

    public void loadClassProperty() {
        if (Objects.nonNull(this.clazz)) {
            Field[] fields;
            for (Field field : fields = this.clazz.getDeclaredFields()) {
                NormalPropertyElement propertyElement;
                if (this.ignorePropertyNames.contains(field.getName()) || this.childElements.contains(propertyElement = new NormalPropertyElement(field.getName(), null))) continue;
                this.addChildElement(propertyElement);
            }
        }
    }

    public void copyChildElement(ContainerElement containerElement) {
        this.childElements.addAll(containerElement.childElements);
    }

    public Iterator<Element> elementIterator() {
        return this.childElements.iterator();
    }

    public boolean isChildEmpty() {
        return this.childElements.isEmpty();
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public void setClazz(Class<?> clazz) {
        this.clazz = clazz;
    }
}

