/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.element;

import com.github.developframework.jsonview.core.element.Jsonview;
import com.github.developframework.jsonview.core.element.JsonviewPackage;
import com.github.developframework.jsonview.exception.JsonviewPackageNotFoundException;
import com.github.developframework.jsonview.exception.ResourceNotUniqueException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class JsonviewConfiguration {
    private Map<String, JsonviewPackage> jsonviewPackages = new HashMap<String, JsonviewPackage>();

    public void addJsonviewPackage(JsonviewPackage jsonviewPackage) {
        String namespace = jsonviewPackage.getNamespace();
        if (this.jsonviewPackages.containsKey(namespace)) {
            throw new ResourceNotUniqueException(String.format("JsonviewPackage namespace \"%s\" is exist.", namespace));
        }
        this.jsonviewPackages.put(namespace, jsonviewPackage);
    }

    public JsonviewPackage getJsonviewPackageByNamespace(String namespace) {
        JsonviewPackage jsonviewPackage = this.jsonviewPackages.get(namespace);
        if (Objects.isNull(jsonviewPackage)) {
            throw new JsonviewPackageNotFoundException(namespace);
        }
        return jsonviewPackage;
    }

    public Jsonview extractJsonview(String namespace, String id) {
        return this.getJsonviewPackageByNamespace(namespace).getJsonviewById(id);
    }
}

