/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.core.element.Jsonview;
import com.github.developframework.jsonview.core.processor.Context;
import com.github.developframework.jsonview.core.processor.DescribeContentProcessor;
import com.github.developframework.jsonview.core.processor.ExtendPortProcessor;
import com.github.developframework.jsonview.core.processor.ObjectProcessor;
import com.github.developframework.jsonview.data.Expression;
import java.util.Optional;

public class JsonviewProcessor
extends ObjectProcessor {
    public JsonviewProcessor(Context context, Jsonview jsonview) {
        super(context, jsonview, Expression.buildObjectExpression(jsonview.getData()));
    }

    public JsonviewProcessor(Context context, Jsonview jsonview, ObjectNode node, Expression parentExpression, String data) {
        super(context, jsonview, parentExpression);
        jsonview.setData(data);
        this.node = node;
    }

    @Override
    protected Expression createExpression(Expression parentExpression) {
        return parentExpression;
    }

    @Override
    public void process(DescribeContentProcessor<? extends Element, ? extends JsonNode> parentProcessor) {
        Optional<Jsonview.Extend> extendOptional = ((Jsonview)this.element).getExtend();
        if (extendOptional.isPresent()) {
            Jsonview.Extend extend = extendOptional.get();
            Jsonview extendJsonview = this.context.getJsonviewConfiguration().extractJsonview(extend.getNamesapce(), extend.getJsonviewId());
            ExtendPortProcessor.ExtendCallback callback = parentProcessorInCallback -> super.process(parentProcessorInCallback);
            this.context.pushExtendCallback(extend.getPort(), callback);
            extendJsonview.createProcessor(this.context, (ObjectNode)this.node, this.expression).ifPresent(processor -> processor.process(parentProcessor));
        } else {
            super.process(parentProcessor);
        }
    }
}

