/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.xml;

import com.github.developframework.jsonview.core.element.Jsonview;
import com.github.developframework.jsonview.core.xml.ContainerElementSaxParser;
import com.github.developframework.jsonview.core.xml.ParserContext;
import com.github.developframework.jsonview.exception.ResourceNotUniqueException;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;

class JsonviewElementSaxParser
extends ContainerElementSaxParser<Jsonview> {
    JsonviewElementSaxParser() {
    }

    @Override
    public String qName() {
        return "jsonview";
    }

    @Override
    public void handleAtStartElement(ParserContext context, Attributes attributes) {
        String id = attributes.getValue("id").trim();
        String data = attributes.getValue("data");
        String extend = attributes.getValue("extend");
        Jsonview jsonview = new Jsonview(context.getJsonviewPackage().getNamespace(), id);
        if (StringUtils.isNotBlank((CharSequence)data)) {
            jsonview.setData(data.trim());
        }
        if (StringUtils.isNotBlank((CharSequence)extend)) {
            String defaultNamespace = context.getJsonviewPackage().getNamespace();
            Jsonview jsonview2 = jsonview;
            jsonview2.getClass();
            jsonview.setExtend(jsonview2.new Jsonview.Extend(extend.trim(), defaultNamespace));
        }
        this.forClass(jsonview, attributes);
        context.getStack().push(jsonview);
    }

    @Override
    public void handleAtEndElement(ParserContext context) {
        Jsonview jsonview = (Jsonview)context.getStack().pop();
        if (context.getJsonviewPackage().containsKey(jsonview.getId())) {
            throw new ResourceNotUniqueException(String.format("Jsonview id \"%s\" already exists.", jsonview.getId()));
        }
        jsonview.loadClassProperty();
        context.getJsonviewPackage().push(jsonview);
    }

    @Override
    protected Jsonview getElementInstance(String data, String alias) {
        return null;
    }

    @Override
    protected void addOtherAttributes(Jsonview element, Attributes attributes) {
    }
}

