/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.data;

import com.github.developframework.jsonview.data.DataModel;
import com.github.developframework.jsonview.data.Expression;
import com.github.developframework.jsonview.exception.JsonviewNoSuchFieldException;
import com.github.developframework.jsonview.utils.ExpressionUtils;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class HashDataModel
implements DataModel {
    private static final long serialVersionUID = 1824745473338821506L;
    private Map<String, Object> dataMap = new HashMap<String, Object>();

    public HashDataModel() {
    }

    public HashDataModel(Map<String, Object> dataMap) {
        this.dataMap.putAll(dataMap);
    }

    @Override
    public void putData(String dataName, Object data) {
        this.dataMap.put(dataName, data);
    }

    @Override
    public Optional<Object> getData(Expression expression) {
        Object value = ExpressionUtils.getValue(this.dataMap, expression);
        return Optional.ofNullable(value);
    }

    @Override
    public Optional<Object> getData(String expression) {
        return this.getData(Expression.buildObjectExpression(expression));
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }

    @Override
    public Optional<List<Expression>> getData(Expression property, String target, Object sourceValue) {
        Optional<Object> objOptional = this.getData(property);
        if (objOptional.isPresent()) {
            Object obj = objOptional.get();
            LinkedList<Expression> expressionList = new LinkedList<Expression>();
            if (obj.getClass().isArray()) {
                Object[] array = (Object[])obj;
                for (int i = 0; i < array.length; ++i) {
                    this.sinple(target, sourceValue, expressionList, array[i], property, i);
                }
            } else if (obj instanceof List) {
                List list = (List)obj;
                int size = list.size();
                for (int i = 0; i < size; ++i) {
                    this.sinple(target, sourceValue, expressionList, list.get(i), property, i);
                }
            } else {
                return Optional.empty();
            }
            return Optional.of(expressionList);
        }
        return Optional.empty();
    }

    private void sinple(String target, Object sourceValue, List<Expression> expressionList, Object object, Expression property, int index) {
        try {
            Field field = object.getClass().getDeclaredField(target);
            field.setAccessible(true);
            Object o = field.get(object);
            if (o == sourceValue || o.equals(sourceValue)) {
                expressionList.add(Expression.buildArrayExpression(property, index));
            }
        }
        catch (NoSuchFieldException e) {
            throw new JsonviewNoSuchFieldException(target);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
        }
    }
}

