/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.element;

import com.github.developframework.jsonview.core.converter.PropertyConverter;
import com.github.developframework.jsonview.core.element.DescribeContentElement;
import com.github.developframework.jsonview.exception.JsonviewExpressionException;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public abstract class PropertyElement
extends DescribeContentElement {
    protected PropertyConverter<?> converter;

    public PropertyElement(String data, String alias) {
        super(data, alias);
    }

    public Optional<PropertyConverter<?>> getConverter() {
        return Optional.ofNullable(this.converter);
    }

    public void setConverter(String converter) {
        if (StringUtils.isBlank((CharSequence)converter)) {
            return;
        }
        try {
            Class<?> clazz = Class.forName(converter);
            this.converter = (PropertyConverter)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new JsonviewExpressionException(e.getMessage() + " is not found.");
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

