package com.github.developframework.jsonview.core.element;

import java.util.Optional;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.jsonview.core.processor.Context;
import com.github.developframework.jsonview.core.processor.JsonviewDuplicateProcessor;
import com.github.developframework.jsonview.core.processor.Processor;
import com.github.developframework.jsonview.data.Expression;

/**
 * Jsonview's duplicate element, it have only jsonview's child elements.
 * 
 * @author qiuzhenhao
 *
 */
public class JsonviewDuplicateElement extends ObjectElement {

	public JsonviewDuplicateElement(Jsonview jsonview) {
		super.copyChildElement(jsonview);
	}

	@Override
	public Optional<Processor<? extends Element, ? extends JsonNode>> createProcessor(Context context, ObjectNode parentNode, Expression parentExpression) {
		JsonviewDuplicateProcessor processor = new JsonviewDuplicateProcessor(context, this, parentExpression);
		processor.setNode(parentNode);
		return Optional.of(processor);
	}
}
