package com.github.developframework.jsonview.core.xml;

import org.xml.sax.Attributes;

import com.github.developframework.jsonview.core.element.LinkPropertyElement;

public class LinkPropertyElementSaxParser extends DescribeContentElementSaxParser<LinkPropertyElement> {

	@Override
	public String qName() {
		return "link-property";
	}

	@Override
	protected LinkPropertyElement getElementInstance(String data, String alias) {
		return new LinkPropertyElement(data, alias);
	}

	@Override
	protected void addOtherAttributes(LinkPropertyElement element, Attributes attributes) {
		element.setNullHidden(attributes.getValue("null-hidden"));
		element.setConverter(attributes.getValue("converter"));
	}

	@Override
	protected void otherOperation(ParserContext context, LinkPropertyElement element) {
		// no operation
	}

}
