/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.jsonview.core.JsonCreator;
import com.github.developframework.jsonview.core.element.Jsonview;
import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import com.github.developframework.jsonview.core.processor.Context;
import com.github.developframework.jsonview.core.processor.JsonviewProcessor;
import com.github.developframework.jsonview.data.DataModel;

class JsonCreatorImpl
implements JsonCreator {
    private JsonviewConfiguration jsonviewConfiguration;

    protected JsonCreatorImpl(JsonviewConfiguration jsonviewConfiguration) {
        this.jsonviewConfiguration = jsonviewConfiguration;
    }

    private ObjectNode constructJson(DataModel dataModel, String namespace, String id) {
        Jsonview jsonview = this.jsonviewConfiguration.extractJsonview(namespace, id);
        ObjectNode root = this.getObjectMapper().createObjectNode();
        Context context = new Context();
        context.setDataModel(dataModel);
        context.setJsonviewConfiguration(this.jsonviewConfiguration);
        JsonviewProcessor processor = new JsonviewProcessor(context, jsonview);
        processor.setNode(root);
        processor.process(null);
        return root;
    }

    @Override
    public String createJson(DataModel dataModel, String namespace, String id) {
        return this.createJson(dataModel, namespace, id, false);
    }

    @Override
    public String createJson(DataModel dataModel, String namespace, String id, boolean isPretty) {
        ObjectNode root = this.constructJson(dataModel, namespace, id);
        try {
            if (isPretty) {
                return this.getObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)root);
            }
            return this.getObjectMapper().writeValueAsString((Object)root);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void printJson(JsonGenerator generator, DataModel dataModel, String namespace, String id) {
        ObjectNode root = this.constructJson(dataModel, namespace, id);
        try {
            this.getObjectMapper().writeValue(generator, (Object)root);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ObjectMapper getObjectMapper() {
        return this.jsonviewConfiguration.getObjectMapper();
    }
}

