/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.developframework.jsonview.core.JsonCreator;
import com.github.developframework.jsonview.core.JsonCreatorImpl;
import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import com.github.developframework.jsonview.core.xml.ConfigurationSource;
import com.github.developframework.jsonview.core.xml.FileConfigurationSource;
import com.github.developframework.jsonview.core.xml.JsonviewConfigurationSaxReader;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class JsonviewFactory {
    private JsonviewConfiguration jsonviewConfiguration;

    public JsonviewFactory(String ... configs) {
        this(new ObjectMapper(), configs);
    }

    public JsonviewFactory(Set<String> configs) {
        this(new ObjectMapper(), configs);
    }

    public JsonviewFactory(ObjectMapper objectMapper, String ... configs) {
        Objects.requireNonNull(objectMapper);
        Objects.requireNonNull(configs);
        HashSet<ConfigurationSource> sources = new HashSet<ConfigurationSource>();
        for (String config : configs) {
            sources.add(new FileConfigurationSource(config));
        }
        JsonviewConfigurationSaxReader reader = new JsonviewConfigurationSaxReader(sources);
        this.jsonviewConfiguration = reader.readConfiguration();
        this.jsonviewConfiguration.setObjectMapper(objectMapper);
    }

    public JsonviewFactory(ObjectMapper objectMapper, Set<String> configs) {
        Objects.requireNonNull(objectMapper);
        Objects.requireNonNull(configs);
        HashSet<ConfigurationSource> sources = new HashSet<ConfigurationSource>();
        for (String config : configs) {
            sources.add(new FileConfigurationSource(config));
        }
        JsonviewConfigurationSaxReader reader = new JsonviewConfigurationSaxReader(sources);
        this.jsonviewConfiguration = reader.readConfiguration();
        this.jsonviewConfiguration.setObjectMapper(objectMapper);
    }

    public JsonviewFactory(ObjectMapper objectMapper, JsonviewConfiguration jsonviewConfiguration) {
        Objects.requireNonNull(jsonviewConfiguration);
        Objects.requireNonNull(objectMapper);
        jsonviewConfiguration.setObjectMapper(objectMapper);
        this.jsonviewConfiguration = jsonviewConfiguration;
    }

    public JsonCreator getJsonCreator() {
        return new JsonCreatorImpl(this.jsonviewConfiguration);
    }

    public JsonviewConfiguration getJsonviewConfiguration() {
        return this.jsonviewConfiguration;
    }

    public ObjectMapper getObjectMapper() {
        return this.jsonviewConfiguration.getObjectMapper();
    }
}

