/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.element;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import com.github.developframework.jsonview.core.element.JsonviewDuplicateElement;
import com.github.developframework.jsonview.core.element.ObjectElement;
import com.github.developframework.jsonview.core.processor.Context;
import com.github.developframework.jsonview.core.processor.JsonviewProcessor;
import com.github.developframework.jsonview.core.processor.Processor;
import com.github.developframework.jsonview.data.Expression;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class Jsonview
extends ObjectElement {
    private String namespace;
    private String id;
    private Extend extend;

    public Jsonview(JsonviewConfiguration configuration, String namespace, String id) {
        super(configuration);
        this.namespace = namespace;
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Optional<Extend> getExtend() {
        return Optional.ofNullable(this.extend);
    }

    public void setExtend(Extend extend) {
        this.extend = extend;
    }

    @Override
    public Optional<Processor<? extends Element, ? extends JsonNode>> createProcessor(Context context, ObjectNode parentNode, Expression parentExpression) {
        JsonviewProcessor jsonviewElementProcessor = new JsonviewProcessor(context, this, parentNode, parentExpression, this.data);
        return Optional.of(jsonviewElementProcessor);
    }

    public JsonviewDuplicateElement createJsonviewDuplicateElement() {
        return new JsonviewDuplicateElement(this.configuration, this);
    }

    public class Extend {
        private String namesapce;
        private String jsonviewId;
        private String port;

        public Extend(String extendStr, String defaultNamespace) {
            String front = StringUtils.substringBefore((String)extendStr, (String)":");
            this.port = StringUtils.substringAfter((String)extendStr, (String)":");
            if (front.contains(".")) {
                this.namesapce = StringUtils.substringBefore((String)front, (String)".");
                this.jsonviewId = StringUtils.substringAfter((String)front, (String)".");
            } else {
                this.namesapce = defaultNamespace;
                this.jsonviewId = front;
            }
        }

        public String getNamesapce() {
            return this.namesapce;
        }

        public String getJsonviewId() {
            return this.jsonviewId;
        }

        public String getPort() {
            return this.port;
        }
    }
}

