/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.jsonview.core.element.ArrayElement;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.core.processor.ContainerProcessor;
import com.github.developframework.jsonview.core.processor.Context;
import com.github.developframework.jsonview.core.processor.DescribeContentProcessor;
import com.github.developframework.jsonview.core.processor.ObjectInArrayProcessor;
import com.github.developframework.jsonview.core.processor.Processor;
import com.github.developframework.jsonview.data.DataModel;
import com.github.developframework.jsonview.data.Expression;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class ArrayProcessor
extends ContainerProcessor<ArrayElement, ArrayNode> {
    public ArrayProcessor(Context context, ArrayElement element, Expression parentExpression) {
        super(context, element, parentExpression);
    }

    @Override
    protected void process(DescribeContentProcessor<? extends Element, ? extends JsonNode> parentProcessor) {
        DataModel dataModel = parentProcessor.getContext().getDataModel();
        Optional<Object> objOptional = dataModel.getData(this.expression);
        if (objOptional.isPresent()) {
            Object obj = objOptional.get();
            int size = 0;
            if (obj.getClass().isArray()) {
                size = ((Object[])obj).length;
            } else if (obj instanceof Collection) {
                size = ((List)obj).size();
            }
            for (int i = 0; i < size; ++i) {
                this.sinple(Expression.buildArrayExpression(this.expression, i), size);
            }
        }
    }

    protected void process(Processor<? extends Element, ? extends JsonNode> parentProcessor, List<Expression> expressionList) {
        int size = expressionList.size();
        for (Expression expression : expressionList) {
            this.sinple(expression, size);
        }
    }

    private void sinple(Expression expression, int size) {
        if (((ArrayElement)this.element).isChildEmpty()) {
            this.empty(expression.getIndex());
        } else {
            ObjectInArrayProcessor childProcessor = new ObjectInArrayProcessor(this.context, ((ArrayElement)this.element).getChildObjectElement(), expression, size);
            ObjectNode objectNode = this.context.getObjectMapper().createObjectNode();
            childProcessor.setNode(objectNode);
            childProcessor.process(null);
            ((ArrayNode)this.node).add((JsonNode)objectNode);
        }
    }

    private void empty(int index) {
        Optional<Object> objectOptional = this.context.getDataModel().getData(Expression.buildArrayExpression(this.expression, index));
        if (!objectOptional.isPresent()) {
            ((ArrayNode)this.node).addNull();
            return;
        }
        Object object = objectOptional.get();
        if (object instanceof String) {
            ((ArrayNode)this.node).add((String)object);
        } else if (object instanceof Integer) {
            ((ArrayNode)this.node).add((Integer)object);
        } else if (object instanceof Long) {
            ((ArrayNode)this.node).add((Long)object);
        } else if (object instanceof Short) {
            ((ArrayNode)this.node).add((int)((Short)object).shortValue());
        } else if (object instanceof Boolean) {
            ((ArrayNode)this.node).add((Boolean)object);
        } else if (object instanceof Float) {
            ((ArrayNode)this.node).add((Float)object);
        } else if (object instanceof Double) {
            ((ArrayNode)this.node).add((Double)object);
        } else if (object instanceof BigDecimal) {
            ((ArrayNode)this.node).add((BigDecimal)object);
        } else if (object instanceof Character) {
            ((ArrayNode)this.node).add((int)((Character)object).charValue());
        } else if (object instanceof Byte) {
            ((ArrayNode)this.node).add((int)((Byte)object).byteValue());
        } else {
            ((ArrayNode)this.node).add(object.toString());
        }
    }
}

