/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.core.element.ObjectElement;
import com.github.developframework.jsonview.core.processor.ContainerProcessor;
import com.github.developframework.jsonview.core.processor.Context;
import com.github.developframework.jsonview.core.processor.DescribeContentProcessor;
import com.github.developframework.jsonview.core.processor.MappingObjectProcessor;
import com.github.developframework.jsonview.core.processor.Processor;
import com.github.developframework.jsonview.data.Expression;
import java.util.Iterator;
import java.util.Optional;

public class ObjectProcessor
extends ContainerProcessor<ObjectElement, ObjectNode> {
    public ObjectProcessor(Context context, ObjectElement element, Expression parentExpression) {
        super(context, element, parentExpression);
    }

    @Override
    public void process(DescribeContentProcessor<? extends Element, ? extends JsonNode> parentProcessor) {
        Iterator<Element> iterator = ((ObjectElement)this.element).elementIterator();
        while (iterator.hasNext()) {
            Element childElement = iterator.next();
            Optional<Processor<? extends Element, ? extends JsonNode>> nextProcessorOptional = childElement.createProcessor(this.context, (ObjectNode)this.node, this.expression);
            nextProcessorOptional.ifPresent(nextProcessor -> {
                this.nextProcessorOtherOperate((Processor<? extends Element, ? extends JsonNode>)nextProcessor);
                nextProcessor.process(this);
            });
        }
    }

    protected void nextProcessorOtherOperate(Processor<? extends Element, ? extends JsonNode> nextProcessor) {
        if (nextProcessor instanceof MappingObjectProcessor) {
            MappingObjectProcessor mappingObjectProcessor = (MappingObjectProcessor)nextProcessor;
            mappingObjectProcessor.setParentArrayExpression(this.expression);
        }
    }
}

