/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.xml;

import com.github.developframework.jsonview.core.element.ContainerElement;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import com.github.developframework.jsonview.core.xml.DescribeContentElementSaxParser;
import com.github.developframework.jsonview.core.xml.ParserContext;
import com.github.developframework.jsonview.exception.JsonviewParseXmlException;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;

abstract class ContainerElementSaxParser<T extends ContainerElement>
extends DescribeContentElementSaxParser<T> {
    ContainerElementSaxParser(JsonviewConfiguration jsonviewConfiguration) {
        super(jsonviewConfiguration);
    }

    protected final void forClass(ContainerElement element, Attributes attributes) {
        String className = attributes.getValue("for-class");
        if (StringUtils.isNotBlank((CharSequence)className)) {
            try {
                element.setClazz(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                throw new JsonviewParseXmlException(String.format("Class \"%s\" is not found, please check configuration file.", className));
            }
        }
    }

    @Override
    public void handleAtEndElement(ParserContext context) {
        ((ContainerElement)context.getStack().pop()).loadClassProperty();
    }

    @Override
    protected void otherOperation(ParserContext context, T element) {
        context.getStack().push((Element)element);
    }
}

