/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.xml;

import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import com.github.developframework.jsonview.core.xml.ArrayElementSaxParser;
import com.github.developframework.jsonview.core.xml.BooleanPropertyElementSaxParser;
import com.github.developframework.jsonview.core.xml.DatePropertyElementSaxParser;
import com.github.developframework.jsonview.core.xml.ElementSaxParser;
import com.github.developframework.jsonview.core.xml.ExtendPortElementSaxParser;
import com.github.developframework.jsonview.core.xml.IgnorePropertyElementSaxParser;
import com.github.developframework.jsonview.core.xml.ImportElementSaxParser;
import com.github.developframework.jsonview.core.xml.JsonviewElementSaxParser;
import com.github.developframework.jsonview.core.xml.JsonviewPackageElementSaxParser;
import com.github.developframework.jsonview.core.xml.LinkObjectElementSaxParser;
import com.github.developframework.jsonview.core.xml.LinkPropertyElementSaxParser;
import com.github.developframework.jsonview.core.xml.MappingObjectElementSaxParser;
import com.github.developframework.jsonview.core.xml.ObjectElementSaxParser;
import com.github.developframework.jsonview.core.xml.ParserContext;
import com.github.developframework.jsonview.core.xml.PropertyElementSaxParser;
import com.github.developframework.jsonview.core.xml.UnixTimestampPropertyElementSaxParser;
import com.github.developframework.jsonview.core.xml.VirtualObjectElementSaxParser;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class JsonviewConfigurationXMLParseHandler
extends DefaultHandler {
    private List<ElementSaxParser> elementSaxParsers;
    private ParserContext context;
    private JsonviewConfiguration configuration;

    public JsonviewConfigurationXMLParseHandler(JsonviewConfiguration configuration) {
        this.configuration = configuration;
        this.elementSaxParsers = new ArrayList<ElementSaxParser>(15);
        this.context = new ParserContext(configuration);
        this.init();
    }

    private void init() {
        this.registerElementSaxParser(new PropertyElementSaxParser(this.configuration));
        this.registerElementSaxParser(new DatePropertyElementSaxParser(this.configuration));
        this.registerElementSaxParser(new BooleanPropertyElementSaxParser(this.configuration));
        this.registerElementSaxParser(new UnixTimestampPropertyElementSaxParser(this.configuration));
        this.registerElementSaxParser(new ObjectElementSaxParser(this.configuration));
        this.registerElementSaxParser(new ArrayElementSaxParser(this.configuration));
        this.registerElementSaxParser(new VirtualObjectElementSaxParser(this.configuration));
        this.registerElementSaxParser(new MappingObjectElementSaxParser(this.configuration));
        this.registerElementSaxParser(new LinkPropertyElementSaxParser(this.configuration));
        this.registerElementSaxParser(new LinkObjectElementSaxParser(this.configuration));
        this.registerElementSaxParser(new IgnorePropertyElementSaxParser(this.configuration));
        this.registerElementSaxParser(new JsonviewElementSaxParser(this.configuration));
        this.registerElementSaxParser(new ImportElementSaxParser(this.configuration));
        this.registerElementSaxParser(new ExtendPortElementSaxParser(this.configuration));
        this.registerElementSaxParser(new JsonviewPackageElementSaxParser(this.configuration));
    }

    private void registerElementSaxParser(ElementSaxParser parser) {
        this.elementSaxParsers.add(parser);
    }

    @Override
    public void startDocument() throws SAXException {
        this.context.getStack().clear();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        for (ElementSaxParser parser : this.elementSaxParsers) {
            if (!parser.qName().equals(qName)) continue;
            parser.handleAtStartElement(this.context, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        for (ElementSaxParser parser : this.elementSaxParsers) {
            if (!parser.qName().equals(qName)) continue;
            parser.handleAtEndElement(this.context);
        }
    }
}

