/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.utils;

import com.github.developframework.jsonview.data.Expression;
import com.github.developframework.jsonview.exception.JsonviewException;
import com.github.developframework.jsonview.exception.JsonviewExpressionException;
import com.github.developframework.jsonview.exception.JsonviewNoSuchFieldException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public final class ExpressionUtils {
    private static final String REGEX_ARRAY = "^\\w*(\\[\\d+\\])+$";

    private ExpressionUtils() {
        throw new AssertionError((Object)("No " + this.getClass().getName() + " instances for you!"));
    }

    public static Object getValue(Object source, Expression expression) {
        return ExpressionUtils.getValue(source, expression.toString());
    }

    private static Object getValue(Object source, String expression) {
        int dotIndex = expression.indexOf(".");
        if (dotIndex == -1) {
            return ExpressionUtils.getPropertyValue(source, expression);
        }
        String property = expression.substring(0, dotIndex);
        String surplusExpression = expression.substring(dotIndex + 1);
        Object value = ExpressionUtils.getPropertyValue(source, property);
        if (Objects.isNull(value)) {
            return null;
        }
        return ExpressionUtils.getValue(value, surplusExpression);
    }

    private static Object getPropertyValue(Object source, String property) {
        if (Objects.isNull(source)) {
            return null;
        }
        if (property.matches(REGEX_ARRAY)) {
            Object value = ExpressionUtils.getPropertyValueFromArray(source, property);
            if ((property = StringUtils.substringAfter((String)property, (String)"]")).isEmpty()) {
                return value;
            }
            return ExpressionUtils.getValue(value, property);
        }
        return ExpressionUtils.getPropertyValueFromObjectOrMap(source, property);
    }

    private static Object getPropertyValueFromArray(Object source, String property) {
        Object propertyObject;
        String propertyName = StringUtils.substringBefore((String)property, (String)"[");
        int number = new Integer(StringUtils.substringBetween((String)property, (String)"[", (String)"]"));
        Object object = propertyObject = propertyName.isEmpty() ? source : ExpressionUtils.getValue(source, propertyName);
        if (propertyObject instanceof List) {
            return ((List)propertyObject).get(number);
        }
        if (propertyObject.getClass().isArray()) {
            return ((Object[])propertyObject)[number];
        }
        throw new JsonviewExpressionException(String.format("\"%s\" isn't an array or list type.", propertyName));
    }

    private static Object getPropertyValueFromObjectOrMap(Object source, String property) {
        if (source instanceof Map) {
            return ((Map)source).get(property);
        }
        try {
            Field field = source.getClass().getDeclaredField(property);
            field.setAccessible(true);
            return field.get(source);
        }
        catch (NoSuchFieldException e) {
            throw new JsonviewNoSuchFieldException(property);
        }
        catch (Exception e) {
            throw new JsonviewException("ExpressionUtils.getValue() is Error.", e);
        }
    }
}

