package com.github.developframework.jsonview.core.element;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.jsonview.core.processor.BooleanPropertyProcessor;
import com.github.developframework.jsonview.core.processor.Context;
import com.github.developframework.jsonview.core.processor.Processor;
import com.github.developframework.jsonview.data.Expression;

import java.util.Optional;

/**
 * property-boolean element
 * 
 * @author qiuzhenhao
 *
 */
public class BooleanPropertyElement extends PropertyElement {

	public BooleanPropertyElement(JsonviewConfiguration configuration, String data, String alias) {
		super(configuration, data, alias);
	}

	@Override
	public Optional<Processor<? extends Element, ? extends JsonNode>> createProcessor(Context context, ObjectNode parentNode, Expression parentExpression) {
		BooleanPropertyProcessor processor = new BooleanPropertyProcessor(context, this, parentExpression);
		processor.setNode(parentNode);
		return Optional.of(processor);
	}

}
