package com.github.developframework.jsonview.core.element;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.jsonview.core.processor.Context;
import com.github.developframework.jsonview.core.processor.ExtendPortProcessor;
import com.github.developframework.jsonview.core.processor.Processor;
import com.github.developframework.jsonview.data.Expression;
import lombok.Getter;

import java.util.Optional;

/**
 * extend-port
 * 
 * @author qiuzhenhao
 */
public class ExtendPortElement extends FunctionalElement {

	@Getter
	private String portName;

	public ExtendPortElement(JsonviewConfiguration configuration, String portName) {
		super(configuration);
		this.portName = portName;
	}

	@Override
	public Optional<Processor<? extends Element, ? extends JsonNode>> createProcessor(Context context, ObjectNode parentNode, Expression parentExpression) {
		ExtendPortProcessor processor = new ExtendPortProcessor(context, this, parentExpression);
		processor.setNode(parentNode);
		return Optional.of(processor);
	}

}
