package com.github.developframework.jsonview.core.element;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.jsonview.core.processor.Context;
import com.github.developframework.jsonview.core.processor.JsonviewProcessor;
import com.github.developframework.jsonview.core.processor.Processor;
import com.github.developframework.jsonview.data.Expression;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.util.Optional;

/**
 * jsonview
 *
 * @author qiuzhenhao
 */
public class Jsonview extends ObjectElement {

    @Getter
    private String namespace;
    @Getter
    private String id;
    @Setter
    private Extend extend;

    public Jsonview(JsonviewConfiguration configuration, String namespace, String id) {
        super(configuration);
        this.namespace = namespace;
        this.id = id;
    }

    @Override
    public Optional<Processor<? extends Element, ? extends JsonNode>> createProcessor(Context context, ObjectNode parentNode, Expression parentExpression) {
        JsonviewProcessor jsonviewElementProcessor = new JsonviewProcessor(context, this, parentNode, parentExpression, data);
        return Optional.of(jsonviewElementProcessor);
    }

    public JsonviewDuplicateElement createJsonviewDuplicateElement() {
        return new JsonviewDuplicateElement(configuration, this);
    }

    public Optional<Extend> getExtend() {
        return Optional.ofNullable(extend);
    }

    /**
     * Extend information encapsulation entities
     *
     * @author qiuzhenhao
     * @since 3.1.0
     */
    public class Extend {
        @Getter
        private String namesapce;
        @Getter
        private String jsonviewId;
        @Getter
        private String port;

        public Extend(String extendStr, String defaultNamespace) {
            String front = StringUtils.substringBefore(extendStr, ":");
            this.port = StringUtils.substringAfter(extendStr, ":");
            if (front.contains(".")) {
                this.namesapce = StringUtils.substringBefore(front, ".");
                this.jsonviewId = StringUtils.substringAfter(front, ".");
            } else {
                this.namesapce = defaultNamespace;
                this.jsonviewId = front;
            }
        }
    }

}
