package com.github.developframework.jsonview.core.element;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.jsonview.core.processor.Context;
import com.github.developframework.jsonview.core.processor.MappingObjectProcessor;
import com.github.developframework.jsonview.core.processor.Processor;
import com.github.developframework.jsonview.data.Expression;
import lombok.Getter;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.util.Optional;

/**
 * mapping-object
 * 
 * @author qiuhenhao
 *
 */
public class MappingObjectElement extends ObjectElement {

	/**
	 * Mapping type enumeration
	 * 
	 * @author qiuzhenhao
	 *
	 */
	public enum MappingType {
		AUTO, SINGLE, MULTIPLE;

		public static MappingType parse(String typeStr) {
			if (StringUtils.isBlank(typeStr)) {
				return AUTO;
			} else {
				return MappingType.valueOf(typeStr.toUpperCase());
			}
		}
	}

	// Condition of the source
	@Getter
	@Setter
	private String source;
	// target
	@Getter
	@Setter
	private String target;
	// The child object element
	@Getter
	private ObjectElement childObjectElement;
	// The child array element
	@Getter
	private ArrayElement childArrayElement;
	// mapping type
	@Getter
	@Setter
	private MappingType mappingType;

	public MappingObjectElement(JsonviewConfiguration configuration, String data, String alias) {
		super(configuration, data, alias);
		childObjectElement = new ObjectElement(configuration, data, alias);
		childArrayElement = new ArrayElement(configuration, data, alias);
	}

	@Override
	public void addChildElement(Element element) {
		super.addChildElement(element);
		this.childObjectElement.addChildElement(element);
		this.childArrayElement.addChildElement(element);
	}

	@Override
	public Optional<Processor<? extends Element, ? extends JsonNode>> createProcessor(Context context, ObjectNode parentNode, Expression parentExpression) {
		MappingObjectProcessor processor = new MappingObjectProcessor(context, this, parentExpression);
		Optional<Object> optional = context.getDataModel().getData(processor.getExpression());
		if (optional.isPresent()) {
			return Optional.of(processor);
		}
		if (!nullHidden) {
			parentNode.putNull(this.showName());
		}
		return Optional.empty();
	}
}
