package com.github.developframework.jsonview.core.element;

import com.github.developframework.jsonview.core.converter.PropertyConverter;
import com.github.developframework.jsonview.exception.JsonviewExpressionException;
import lombok.Setter;
import org.apache.commons.lang3.StringUtils;

import java.util.Optional;

/**
 * The basic property element
 * 
 * @author qiuhenhao
 *
 */
public abstract class PropertyElement extends DescribeContentElement {

	@Setter
	protected String converterValue;

	public PropertyElement(JsonviewConfiguration configuration, String data, String alias) {
		super(configuration, data, alias);
	}

	public Optional<String> getConverterValue() {
		return Optional.ofNullable(converterValue);
	}
}
