package com.github.developframework.jsonview.core.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import com.github.developframework.jsonview.data.DataModel;
import lombok.Getter;
import lombok.Setter;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

/**
 * processor's context
 * 
 * @author qiuzhenhao
 *
 */
public class Context {

	@Getter
	@Setter
	private DataModel dataModel;
	@Setter
	private JsonviewConfiguration jsonviewConfiguration;
	private Map<String, ExtendPortProcessor.ExtendCallback> extendPortMap = new HashMap<>();

	public ObjectMapper getObjectMapper() {
		return jsonviewConfiguration.getObjectMapper();
	}

	public JsonviewConfiguration getJsonviewConfiguration() {
		return jsonviewConfiguration;
	}

	public void pushExtendCallback(String portName, ExtendPortProcessor.ExtendCallback callback) {
		extendPortMap.put(portName, callback);
	}

	public Optional<ExtendPortProcessor.ExtendCallback> getExtendCallback(String port) {
		return Optional.ofNullable(extendPortMap.get(port));
	}

}
