package com.github.developframework.jsonview.core.xml;

import com.github.developframework.jsonview.core.element.ArrayElement;
import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import org.xml.sax.Attributes;

/**
 * A parser for xml element: array
 * 
 * @author qiuzhenhao
 *
 */
class ArrayElementSaxParser extends ContainerElementSaxParser<ArrayElement> {

	ArrayElementSaxParser(JsonviewConfiguration jsonviewConfiguration) {
		super(jsonviewConfiguration);
	}

	@Override
	public String qName() {
		return "array";
	}

	@Override
	protected ArrayElement getElementInstance(String data, String alias) {
		return new ArrayElement(jsonviewConfiguration, data, alias);
	}

	@Override
	protected void addOtherAttributes(ArrayElement element, Attributes attributes) {
		element.setNullHidden(attributes.getValue("null-hidden"));
		element.setMapFunctionValue(attributes.getValue("map-function"));
		forClass(element, attributes);
	}

}
