package com.github.developframework.jsonview.core.xml;

import com.github.developframework.jsonview.core.element.DatePropertyElement;
import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import org.xml.sax.Attributes;

/**
 * A parser for xml element: property-date
 * 
 * @author qiuzhenhao
 *
 */
class DatePropertyElementSaxParser extends DescribeContentElementSaxParser<DatePropertyElement> {

	DatePropertyElementSaxParser(JsonviewConfiguration jsonviewConfiguration) {
		super(jsonviewConfiguration);
	}

	@Override
	public String qName() {
		return "property-date";
	}

	@Override
	protected DatePropertyElement getElementInstance(String data, String alias) {
		return new DatePropertyElement(jsonviewConfiguration, data, alias);
	}

	@Override
	protected void addOtherAttributes(DatePropertyElement element, Attributes attributes) {
		element.setPattern(attributes.getValue("pattern"));
		element.setNullHidden(attributes.getValue("null-hidden"));
		element.setConverterValue(attributes.getValue("converter"));
	}

	@Override
	protected void otherOperation(ParserContext context, DatePropertyElement element) {
		// no operation
	}

}
