package com.github.developframework.jsonview.core.xml;

import com.github.developframework.jsonview.core.element.ContainerElement;
import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import org.xml.sax.Attributes;

/**
 * A parser for xml element: ignore-property
 * 
 * @author qiuzhenhao
 *
 */
class IgnorePropertyElementSaxParser extends ConfigableElementSaxParser implements ElementSaxParser {

	IgnorePropertyElementSaxParser(JsonviewConfiguration jsonviewConfiguration) {
		super(jsonviewConfiguration);
	}

	@Override
	public String qName() {
		return "ignore-property";
	}

	@Override
	public void handleAtStartElement(ParserContext context, Attributes attributes) {
		final String name = attributes.getValue("name").trim();
		((ContainerElement) context.getStack().peek()).addIgnoreProperty(name);
	}

	@Override
	public void handleAtEndElement(ParserContext context) {
		// no operation
	}

}
