package com.github.developframework.jsonview.core.xml;

import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

import java.util.ArrayList;
import java.util.List;

/**
 * SAX Handler
 * 
 * @author qiuzhenhao
 *
 */
class JsonviewConfigurationXMLParseHandler extends DefaultHandler {

	// ElementSaxParser list
	private List<ElementSaxParser> elementSaxParsers;
	// context
	private ParserContext context;

	private JsonviewConfiguration configuration;

	public JsonviewConfigurationXMLParseHandler(JsonviewConfiguration configuration) {
		this.configuration = configuration;
		this.elementSaxParsers = new ArrayList<>(15);
		this.context = new ParserContext(configuration);
		init();
	}

	/**
	 * initialize for register all ElementSaxParser
	 */
	private void init() {
		registerElementSaxParser(new PropertyElementSaxParser(configuration));
		registerElementSaxParser(new DatePropertyElementSaxParser(configuration));
		registerElementSaxParser(new BooleanPropertyElementSaxParser(configuration));
		registerElementSaxParser(new UnixTimestampPropertyElementSaxParser(configuration));
		registerElementSaxParser(new ObjectElementSaxParser(configuration));
		registerElementSaxParser(new ArrayElementSaxParser(configuration));
		registerElementSaxParser(new VirtualObjectElementSaxParser(configuration));
		registerElementSaxParser(new MappingObjectElementSaxParser(configuration));
		registerElementSaxParser(new LinkPropertyElementSaxParser(configuration));
		registerElementSaxParser(new LinkObjectElementSaxParser(configuration));

		registerElementSaxParser(new IgnorePropertyElementSaxParser(configuration));
		registerElementSaxParser(new JsonviewElementSaxParser(configuration));
		registerElementSaxParser(new ImportElementSaxParser(configuration));
		registerElementSaxParser(new ExtendPortElementSaxParser(configuration));
		registerElementSaxParser(new JsonviewPackageElementSaxParser(configuration));
	}

	/**
	 * register parser
	 * 
	 * @param parser parser
	 */
	private void registerElementSaxParser(ElementSaxParser parser) {
		elementSaxParsers.add(parser);
	}

	/**
	 * sax start document
	 */
	@Override
	public void startDocument() throws SAXException {
		context.getStack().clear();
	}

	/**
	 * sax start element
	 */
	@Override
	public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
		for (ElementSaxParser parser : elementSaxParsers) {
			if (parser.qName().equals(qName)) {
				parser.handleAtStartElement(context, attributes);
			}
		}
	}

	/**
	 * sax end element
	 */
	@Override
	public void endElement(String uri, String localName, String qName) throws SAXException {
		for (ElementSaxParser parser : elementSaxParsers) {
			if (parser.qName().equals(qName)) {
				parser.handleAtEndElement(context);
			}
		}
	}
}
