package com.github.developframework.jsonview.core.xml;

import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import com.github.developframework.jsonview.core.element.NormalPropertyElement;
import com.github.developframework.jsonview.core.element.PropertyElement;
import org.xml.sax.Attributes;

/**
 * A parser for xml element: property
 * 
 * @author qiuzhenhao
 *
 */
class PropertyElementSaxParser extends DescribeContentElementSaxParser<PropertyElement> {

	PropertyElementSaxParser(JsonviewConfiguration jsonviewConfiguration) {
		super(jsonviewConfiguration);
	}

	@Override
	public String qName() {
		return "property";
	}

	@Override
	protected PropertyElement getElementInstance(String data, String alias) {
		return new NormalPropertyElement(jsonviewConfiguration, data, alias);
	}

	@Override
	protected void addOtherAttributes(PropertyElement element, Attributes attributes) {
		element.setNullHidden(attributes.getValue("null-hidden"));
		element.setConverterValue(attributes.getValue("converter"));
	}

	@Override
	protected void otherOperation(ParserContext context, PropertyElement element) {
		// no operation
	}

}
