package com.github.developframework.jsonview.core.xml;

import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import com.github.developframework.jsonview.core.element.VirtualObjectElement;
import org.xml.sax.Attributes;

/**
 * A parser for xml element: virtual-object
 * 
 * @author qiuzhenhao
 *
 */
public class VirtualObjectElementSaxParser extends ContainerElementSaxParser<VirtualObjectElement> {

	VirtualObjectElementSaxParser(JsonviewConfiguration jsonviewConfiguration) {
		super(jsonviewConfiguration);
	}

	@Override
	public String qName() {
		return "virtual-object";
	}

	@Override
	protected VirtualObjectElement getElementInstance(String data, String alias) {
		return new VirtualObjectElement(jsonviewConfiguration, alias);
	}

	@Override
	protected void addOtherAttributes(VirtualObjectElement element, Attributes attributes) {
		// no operation
	}

}
