/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.developframework.jsonview.boot.JsonviewProperties;
import com.github.developframework.jsonview.boot.JsonviewWebMvcConfigurer;
import com.github.developframework.jsonview.core.JsonviewFactory;
import com.github.developframework.jsonview.spring.JsonviewScanLoader;
import com.github.developframework.jsonview.springmvc.DataModelReturnValueHandler;
import com.github.developframework.jsonview.springmvc.JsonviewResponseReturnValueHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={JsonviewWebMvcConfigurer.class})
@AutoConfigureAfter(value={JacksonAutoConfiguration.class})
public class JsonviewComponentAutoConfiguration {
    private static Logger logger = LoggerFactory.getLogger(JsonviewComponentAutoConfiguration.class);

    @Bean
    @Autowired
    @ConditionalOnProperty(name={"jsonview.objectmapper.usedefault"}, havingValue="true", matchIfMissing=true)
    public JsonviewFactory getJsonviewFactoryForDefaultObjectMapper(JsonviewProperties jsonviewProperties, ObjectMapper objectMapper) {
        logger.info("Jsonview framework use Jackson default ObjectMapper.");
        JsonviewScanLoader loader = new JsonviewScanLoader(jsonviewProperties.getLocations());
        return loader.createJsonviewFactory(objectMapper);
    }

    @Bean
    @Autowired
    @ConditionalOnProperty(name={"jsonview.objectmapper.usedefault"}, havingValue="false")
    public JsonviewFactory getJsonviewFactoryForNewObjectMapper(JsonviewProperties jsonviewProperties) {
        logger.info("Jsonview framework use a new ObjectMapper.");
        JsonviewScanLoader loader = new JsonviewScanLoader(jsonviewProperties.getLocations());
        return loader.createJsonviewFactory();
    }

    @Bean
    @Autowired
    public DataModelReturnValueHandler getDataModelReturnValueHandler(JsonviewFactory jsonviewFactory) {
        return new DataModelReturnValueHandler(jsonviewFactory);
    }

    @Bean
    @Autowired
    public JsonviewResponseReturnValueHandler getJsonviewResponseReturnValueHandler(JsonviewFactory jsonviewFactory) {
        return new JsonviewResponseReturnValueHandler(jsonviewFactory);
    }
}

