/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.spring;

import com.github.developframework.jsonview.core.JsonviewFactory;
import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import com.github.developframework.jsonview.core.xml.JsonviewConfigurationSaxReader;
import com.github.developframework.jsonview.spring.SpringResourceConfigurationSource;
import java.io.IOException;
import java.util.HashSet;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class JsonviewScanLoader {
    private String locations;

    public JsonviewScanLoader(String locations) {
        this.locations = locations;
    }

    public JsonviewConfiguration createJsonviewConfiguration() {
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            Resource[] resources = resolver.getResources(this.locations);
            HashSet<SpringResourceConfigurationSource> sources = new HashSet<SpringResourceConfigurationSource>(resources.length);
            for (int i = 0; i < resources.length; ++i) {
                sources.add(new SpringResourceConfigurationSource(resources[i]));
            }
            JsonviewConfigurationSaxReader reader = new JsonviewConfigurationSaxReader(sources);
            return reader.readConfiguration();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public JsonviewFactory createJsonviewFactory() {
        return new JsonviewFactory(this.createJsonviewConfiguration());
    }

    public String getLocations() {
        return this.locations;
    }
}

