package com.github.developframework.jsonview.spring;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.StringUtils;

import com.github.developframework.jsonview.core.JsonviewFactory;
import com.github.developframework.jsonview.core.element.JsonviewConfiguration;
import com.github.developframework.jsonview.core.xml.ConfigurationSource;
import com.github.developframework.jsonview.core.xml.JsonviewConfigurationSaxReader;

/**
 * Jsonview configuration scanning loader
 * 
 * @author qiuzhenhao
 *
 */
public class JsonviewScanLoader {

	private String locations;

	public JsonviewScanLoader(String locations) {
		this.locations = locations;
	}

	/**
	 * create jsonviewConfiguration
	 * 
	 * @return jsonviewConfiguration
	 */
	public JsonviewConfiguration createJsonviewConfiguration() {
		final String[] locationsArray = StringUtils.tokenizeToStringArray(locations, ConfigurableApplicationContext.CONFIG_LOCATION_DELIMITERS);
		final ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
		try {
			final Set<ConfigurationSource> sources = new HashSet<>();
			for (String locationOne : locationsArray) {
				final Resource[] resources = resolver.getResources(locationOne);
				for (int i = 0; i < resources.length; i++) {
					sources.add(new SpringResourceConfigurationSource(resources[i]));
				}
			}
			final JsonviewConfigurationSaxReader reader = new JsonviewConfigurationSaxReader(sources);
			return reader.readConfiguration();
		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}
	}

	/**
	 * create JsonviewFactory
	 * 
	 * @return JsonviewFactory
	 */
	public JsonviewFactory createJsonviewFactory() {
		return new JsonviewFactory(createJsonviewConfiguration());
	}

	public String getLocations() {
		return locations;
	}

}
