/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.element;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.github.developframework.expression.ArrayExpression;
import com.github.developframework.expression.Expression;
import com.github.developframework.expression.ObjectExpression;
import com.github.developframework.jsonview.core.JsonviewConfiguration;
import com.github.developframework.jsonview.core.data.DataDefinition;
import com.github.developframework.jsonview.core.element.Element;
import org.apache.commons.lang3.StringUtils;

public abstract class ContentElement
extends Element {
    protected DataDefinition dataDefinition;
    protected String alias;
    protected boolean nullHidden;

    public ContentElement(JsonviewConfiguration configuration, String namespace, String templateId, DataDefinition dataDefinition, String alias) {
        super(configuration, namespace, templateId);
        this.dataDefinition = dataDefinition;
        this.alias = alias;
    }

    public void setNullHidden(String nullHiddenStr) {
        this.nullHidden = StringUtils.isBlank((CharSequence)nullHiddenStr) ? false : new Boolean(nullHiddenStr);
    }

    public String showName() {
        if (StringUtils.isNotBlank((CharSequence)this.alias)) {
            return this.alias;
        }
        String expressionString = this.expressionString();
        PropertyNamingStrategy strategy = this.configuration.getObjectMapper().getPropertyNamingStrategy();
        if (strategy == null) {
            return expressionString;
        }
        return strategy.nameForField(null, null, expressionString);
    }

    private String expressionString() {
        Expression expression = this.dataDefinition.getExpression();
        if (expression instanceof ObjectExpression) {
            return ((ObjectExpression)expression).getPropertyName();
        }
        if (expression instanceof ArrayExpression) {
            ArrayExpression arrayExpression = (ArrayExpression)expression;
            return arrayExpression.getPropertyName() + "_" + arrayExpression.getIndex();
        }
        return "aaa";
    }

    public DataDefinition getDataDefinition() {
        return this.dataDefinition;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isNullHidden() {
        return this.nullHidden;
    }

    public void setDataDefinition(DataDefinition dataDefinition) {
        this.dataDefinition = dataDefinition;
    }
}

