/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.expression.ArrayExpression;
import com.github.developframework.expression.Expression;
import com.github.developframework.expression.ObjectExpression;
import com.github.developframework.jsonview.core.data.DataModel;
import com.github.developframework.jsonview.core.dynamic.MapFunction;
import com.github.developframework.jsonview.core.element.ArrayElement;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.core.exception.InvalidArgumentsException;
import com.github.developframework.jsonview.core.exception.JsonviewException;
import com.github.developframework.jsonview.core.processor.ContainerProcessor;
import com.github.developframework.jsonview.core.processor.ContentProcessor;
import com.github.developframework.jsonview.core.processor.ObjectInArrayProcessor;
import com.github.developframework.jsonview.core.processor.ProcessContext;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayProcessor
extends ContainerProcessor<ArrayElement, ArrayNode> {
    private static final Logger log = LoggerFactory.getLogger(ArrayProcessor.class);
    private Optional<MapFunction> mapFunctionOptional;

    public ArrayProcessor(ProcessContext processContext, ArrayElement element, Expression parentExpression) {
        super(processContext, element, parentExpression);
        this.mapFunctionOptional = this.mapFunction(element.getMapFunctionValueOptional(), processContext.getDataModel());
        if (this.mapFunctionOptional.isPresent() && !element.isChildElementEmpty()) {
            log.warn("The child element invalid, because you use \"map-function\" attribute.");
        }
    }

    @Override
    protected boolean prepare(ContentProcessor<? extends Element, ? extends JsonNode> parentProcessor) {
        Optional<Object> valueOptional = this.processContext.getDataModel().getData(this.expression);
        if (valueOptional.isPresent()) {
            this.value = valueOptional.get();
            this.node = ((ObjectNode)parentProcessor.getNode()).putArray(((ArrayElement)this.element).showName());
            return true;
        }
        if (!((ArrayElement)this.element).isNullHidden()) {
            ((ObjectNode)parentProcessor.getNode()).putNull(((ArrayElement)this.element).showName());
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentProcessor<? extends Element, ? extends JsonNode> parentProcessor) {
        int size;
        if (this.value.getClass().isArray()) {
            size = ((Object[])this.value).length;
        } else if (this.value instanceof List) {
            size = ((List)this.value).size();
        } else {
            throw new InvalidArgumentsException("data", this.expression.toString(), "Data must be array or List type.");
        }
        for (int i = 0; i < size; ++i) {
            this.single(ArrayExpression.fromObject((ObjectExpression)((ObjectExpression)this.expression), (int)i), size);
        }
    }

    protected final void single(ArrayExpression arrayExpression, int size) {
        if (((ArrayElement)this.element).isChildElementEmpty() || this.mapFunctionOptional.isPresent()) {
            this.empty(arrayExpression.getIndex());
        } else {
            ObjectInArrayProcessor childProcessor = new ObjectInArrayProcessor(this.processContext, ((ArrayElement)this.element).getItemObjectElement(), (Expression)arrayExpression, size);
            childProcessor.process(this);
            ((ArrayNode)this.node).add(childProcessor.getNode());
        }
    }

    private void empty(int index) {
        Optional<Object> objectOptional = this.processContext.getDataModel().getData((Expression)ArrayExpression.fromObject((ObjectExpression)((ObjectExpression)this.expression), (int)index));
        if (!objectOptional.isPresent()) {
            ((ArrayNode)this.node).addNull();
            return;
        }
        Object object = objectOptional.get();
        this.mapFunctionOptional.ifPresent(mapFunction -> mapFunction.apply(object, index));
        if (object instanceof String) {
            ((ArrayNode)this.node).add((String)object);
        } else if (object instanceof Integer) {
            ((ArrayNode)this.node).add((Integer)object);
        } else if (object instanceof Long) {
            ((ArrayNode)this.node).add((Long)object);
        } else if (object instanceof Short) {
            ((ArrayNode)this.node).add((int)((Short)object).shortValue());
        } else if (object instanceof Boolean) {
            ((ArrayNode)this.node).add((Boolean)object);
        } else if (object instanceof Float) {
            ((ArrayNode)this.node).add((Float)object);
        } else if (object instanceof Double) {
            ((ArrayNode)this.node).add((Double)object);
        } else if (object instanceof BigDecimal) {
            ((ArrayNode)this.node).add((BigDecimal)object);
        } else if (object instanceof Character) {
            ((ArrayNode)this.node).add((int)((Character)object).charValue());
        } else if (object instanceof Byte) {
            ((ArrayNode)this.node).add((int)((Byte)object).byteValue());
        } else {
            ((ArrayNode)this.node).add(object.toString());
        }
    }

    private Optional<MapFunction> mapFunction(Optional<String> mapFunctionValueOptional, DataModel dataModel) {
        if (mapFunctionValueOptional.isPresent()) {
            String mapFunctionValue = mapFunctionValueOptional.get();
            Optional<Object> mapFunctionOptional = dataModel.getData(mapFunctionValue);
            Object obj = mapFunctionOptional.orElseGet(() -> {
                try {
                    return Class.forName(mapFunctionValue).newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new InvalidArgumentsException("map-function", mapFunctionValue, "Class not found, and it's also not a expression.");
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new JsonviewException("Can't new mapFunction instance.");
                }
            });
            if (obj instanceof MapFunction) {
                return Optional.of((MapFunction)obj);
            }
            throw new InvalidArgumentsException("map-function", mapFunctionValue, "It's not a MapFunction instance.");
        }
        return Optional.empty();
    }
}

