/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.processor;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.expression.Expression;
import com.github.developframework.jsonview.core.element.PropertyElement;
import com.github.developframework.jsonview.core.processor.ProcessContext;
import com.github.developframework.jsonview.core.processor.PropertyProcessor;
import java.util.HashSet;
import java.util.Set;

public class BooleanPropertyProcessor
extends PropertyProcessor {
    private static final Set<Class<?>> ACCEPT_CLASS_SET = new HashSet(8);

    public BooleanPropertyProcessor(ProcessContext processContext, PropertyElement element, Expression parentExpression) {
        super(processContext, element, parentExpression);
    }

    @Override
    protected boolean support(Class<?> sourceClass) {
        return ACCEPT_CLASS_SET.contains(sourceClass);
    }

    @Override
    protected void handle(ObjectNode parentNode, Class<?> clazz, Object value, String showName) {
        boolean v = false;
        if (clazz == Boolean.class) {
            v = (Boolean)value;
        } else if (clazz == Integer.class) {
            v = (Integer)value != 0;
        } else if (clazz == Long.class) {
            v = (Long)value != 0L;
        } else if (clazz == Short.class) {
            v = (Short)value != 0;
        } else {
            parentNode.putNull(showName);
            return;
        }
        parentNode.put(showName, v);
    }

    static {
        ACCEPT_CLASS_SET.add(Boolean.TYPE);
        ACCEPT_CLASS_SET.add(Boolean.class);
        ACCEPT_CLASS_SET.add(Integer.TYPE);
        ACCEPT_CLASS_SET.add(Integer.class);
        ACCEPT_CLASS_SET.add(Long.TYPE);
        ACCEPT_CLASS_SET.add(Long.class);
        ACCEPT_CLASS_SET.add(Short.TYPE);
        ACCEPT_CLASS_SET.add(Short.class);
    }
}

