/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.data;

import com.github.developframework.expression.Expression;
import com.github.developframework.expression.ExpressionUtils;
import com.github.developframework.jsonview.core.data.DataModel;
import com.github.developframework.jsonview.core.exception.DataUndefinedException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class HashDataModel
implements DataModel {
    private Map<String, Object> dataMap = new HashMap<String, Object>();

    public HashDataModel() {
    }

    public HashDataModel(Map<String, Object> dataMap) {
        this.dataMap.putAll(dataMap);
    }

    @Override
    public void putData(String dataName, Object data) {
        this.dataMap.put(dataName, data);
    }

    @Override
    public Optional<Object> getData(Expression expression) {
        return Optional.ofNullable(ExpressionUtils.getValue(this.dataMap, (Expression)expression));
    }

    @Override
    public Optional<Object> getData(String expressionValue) {
        return this.getData(Expression.parse((String)expressionValue));
    }

    @Override
    public Object getDataRequired(Expression expression) {
        Object value = ExpressionUtils.getValue(this.dataMap, (Expression)expression);
        if (value == null) {
            throw new DataUndefinedException(expression.toString());
        }
        return value;
    }

    @Override
    public Object getDataRequired(String expressionValue) {
        return this.getDataRequired(Expression.parse((String)expressionValue));
    }

    public static final DataModel singleton(String dataName, Object data) {
        HashDataModel dataModel = new HashDataModel();
        dataModel.putData(dataName, data);
        return dataModel;
    }

    public Map<String, Object> getDataMap() {
        return this.dataMap;
    }
}

