/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.expression.Expression;
import com.github.developframework.jsonview.core.dynamic.Condition;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.core.element.IfElement;
import com.github.developframework.jsonview.core.exception.JsonviewException;
import com.github.developframework.jsonview.core.processor.ContentProcessor;
import com.github.developframework.jsonview.core.processor.FunctionalProcessor;
import com.github.developframework.jsonview.core.processor.ProcessContext;
import com.github.developframework.jsonview.core.processor.Processor;
import java.util.Iterator;
import java.util.Optional;

public class IfProcessor
extends FunctionalProcessor<IfElement, ObjectNode> {
    public IfProcessor(ProcessContext processContext, IfElement element, ObjectNode node, Expression parentExpression) {
        super(processContext, element, node, parentExpression);
    }

    @Override
    protected void handleCoreLogic(ContentProcessor<? extends Element, ? extends JsonNode> parentProcessor) {
        boolean verifyResult;
        String conditionValue = ((IfElement)this.element).getConditionValue();
        Optional<Object> conditionOptional = this.processContext.getDataModel().getData(conditionValue);
        Object condition = conditionOptional.orElseGet(() -> {
            try {
                return Class.forName(conditionValue).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new JsonviewException("The condition's Class \"%s\" not found, and it's also not a expression.", conditionValue);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new JsonviewException("Can't new condition instance.");
            }
        });
        if (condition instanceof Boolean) {
            verifyResult = (Boolean)condition;
        } else if (condition instanceof Condition) {
            verifyResult = ((Condition)condition).verify(this.processContext.getDataModel(), parentProcessor.getExpression());
        } else {
            throw new JsonviewException("The expression \"%s\" is not Condition instance.", ((IfElement)this.element).getConditionValue());
        }
        if (verifyResult) {
            this.executeIfTrue(parentProcessor);
        } else {
            this.executeIfFalse(parentProcessor);
        }
    }

    private void executeIfTrue(ContentProcessor<? extends Element, ? extends JsonNode> parentProcessor) {
        Iterator<Element> iterator = ((IfElement)this.element).childElementIterator();
        while (iterator.hasNext()) {
            Element childElement = iterator.next();
            Processor<? extends Element, ? extends JsonNode> nextProcessor = childElement.createProcessor(this.processContext, (ObjectNode)this.node, this.expression);
            nextProcessor.process(parentProcessor);
        }
    }

    private void executeIfFalse(ContentProcessor<? extends Element, ? extends JsonNode> parentProcessor) {
        ((IfElement)this.element).getElseElement().ifPresent(elseElement -> {
            Processor<? extends Element, ? extends JsonNode> elseProcessor = elseElement.createProcessor(this.processContext, (ObjectNode)parentProcessor.getNode(), parentProcessor.getExpression());
            elseProcessor.process(parentProcessor);
        });
    }
}

