/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.expression.Expression;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.core.element.ObjectElement;
import com.github.developframework.jsonview.core.processor.ContainerProcessor;
import com.github.developframework.jsonview.core.processor.ContentProcessor;
import com.github.developframework.jsonview.core.processor.ProcessContext;
import com.github.developframework.jsonview.core.processor.Processor;
import java.util.Iterator;
import java.util.Optional;

public class ObjectProcessor
extends ContainerProcessor<ObjectElement, ObjectNode> {
    public ObjectProcessor(ProcessContext processContext, ObjectElement element, Expression parentExpression) {
        super(processContext, element, parentExpression);
    }

    @Override
    protected boolean prepare(ContentProcessor<? extends Element, ? extends JsonNode> parentProcessor) {
        Optional<Object> valueOptional = this.processContext.getDataModel().getData(this.expression);
        if (valueOptional.isPresent()) {
            this.value = valueOptional.get();
            this.node = ((ObjectNode)parentProcessor.getNode()).putObject(((ObjectElement)this.element).showName());
            return true;
        }
        if (!((ObjectElement)this.element).isNullHidden()) {
            ((ObjectNode)this.node).putNull(((ObjectElement)this.element).showName());
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentProcessor<? extends Element, ? extends JsonNode> parentProcessor) {
        Iterator<Element> iterator = ((ObjectElement)this.element).childElementIterator();
        while (iterator.hasNext()) {
            Element childElement = iterator.next();
            Processor<? extends Element, ? extends JsonNode> childProcessor = childElement.createProcessor(this.processContext, (ObjectNode)this.node, this.expression);
            childProcessor.process(this);
        }
    }
}

