/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.processor;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.expression.Expression;
import com.github.developframework.jsonview.core.dynamic.PropertyConverter;
import com.github.developframework.jsonview.core.element.Element;
import com.github.developframework.jsonview.core.element.PropertyElement;
import com.github.developframework.jsonview.core.exception.InvalidArgumentsException;
import com.github.developframework.jsonview.core.exception.JsonviewException;
import com.github.developframework.jsonview.core.processor.ContentProcessor;
import com.github.developframework.jsonview.core.processor.ProcessContext;
import java.util.Optional;

public abstract class PropertyProcessor
extends ContentProcessor<PropertyElement, ObjectNode> {
    public PropertyProcessor(ProcessContext processContext, PropertyElement element, Expression parentExpression) {
        super(processContext, element, parentExpression);
    }

    @Override
    protected boolean prepare(ContentProcessor<? extends Element, ? extends JsonNode> parentProcessor) {
        Optional<Object> valueOptional = this.processContext.getDataModel().getData(this.expression);
        if (valueOptional.isPresent()) {
            this.value = valueOptional.get();
            this.node = (ObjectNode)parentProcessor.getNode();
            return true;
        }
        if (!((PropertyElement)this.element).isNullHidden()) {
            ((ObjectNode)parentProcessor.getNode()).putNull(((PropertyElement)this.element).showName());
        }
        return false;
    }

    @Override
    protected void handleCoreLogic(ContentProcessor<? extends Element, ? extends JsonNode> parentProcessor) {
        Optional<Object> convertValueOptional = ((PropertyElement)this.element).getConverterValue().map(converterValue -> {
            Optional<Object> converterOptional = this.processContext.getDataModel().getData((String)converterValue);
            Object obj = converterOptional.orElseGet(() -> {
                try {
                    return Class.forName(converterValue).newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new InvalidArgumentsException("converter", (String)converterValue, "Class not found, and it's also not a expression.");
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new JsonviewException("Can't new converter instance.");
                }
            });
            if (obj instanceof PropertyConverter) {
                return ((PropertyConverter)obj).convert(this.value);
            }
            throw new InvalidArgumentsException("converter", (String)converterValue, "It's not a PropertyConverter instance.");
        });
        Object convertValue = convertValueOptional.orElse(this.value);
        Class<?> convertValueClass = convertValue.getClass();
        if (this.support(convertValueClass)) {
            this.handle((ObjectNode)this.node, convertValueClass, convertValue, ((PropertyElement)this.element).showName());
        }
    }

    protected abstract boolean support(Class<?> var1);

    protected abstract void handle(ObjectNode var1, Class<?> var2, Object var3, String var4);
}

