/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.xml;

import com.github.developframework.jsonview.core.JsonviewConfiguration;
import com.github.developframework.jsonview.core.xml.ArrayElementSaxParser;
import com.github.developframework.jsonview.core.xml.BooleanPropertyElementSaxParser;
import com.github.developframework.jsonview.core.xml.DatePropertyElementSaxParser;
import com.github.developframework.jsonview.core.xml.ElementSaxParser;
import com.github.developframework.jsonview.core.xml.ElseElementSaxParser;
import com.github.developframework.jsonview.core.xml.ExtendPortElementSaxParser;
import com.github.developframework.jsonview.core.xml.IfElementSaxParser;
import com.github.developframework.jsonview.core.xml.IgnorePropertyElementSaxParser;
import com.github.developframework.jsonview.core.xml.IncludeElementSaxParser;
import com.github.developframework.jsonview.core.xml.LinkElementSaxParser;
import com.github.developframework.jsonview.core.xml.ObjectElementSaxParser;
import com.github.developframework.jsonview.core.xml.ParseContext;
import com.github.developframework.jsonview.core.xml.PropertyElementSaxParser;
import com.github.developframework.jsonview.core.xml.PrototypeElementSaxParser;
import com.github.developframework.jsonview.core.xml.RelevanceElementParser;
import com.github.developframework.jsonview.core.xml.TemplateElementSaxParser;
import com.github.developframework.jsonview.core.xml.TemplatePackageElementSaxParser;
import com.github.developframework.jsonview.core.xml.UnixTimestampPropertyElementSaxParser;
import com.github.developframework.jsonview.core.xml.VirtualObjectElementSaxParser;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ConfigurationSaxParseHandler
extends DefaultHandler {
    private List<ElementSaxParser> elementSaxParserChain;
    private ParseContext parseContext;
    private JsonviewConfiguration configuration;

    public ConfigurationSaxParseHandler(JsonviewConfiguration configuration) {
        this.configuration = configuration;
        this.elementSaxParserChain = new ArrayList<ElementSaxParser>(15);
        this.parseContext = new ParseContext(configuration);
        this.registerDefaultElementSaxParser();
    }

    private void registerDefaultElementSaxParser() {
        this.registerElementSaxParser(new PropertyElementSaxParser(this.configuration));
        this.registerElementSaxParser(new DatePropertyElementSaxParser(this.configuration));
        this.registerElementSaxParser(new ObjectElementSaxParser(this.configuration));
        this.registerElementSaxParser(new ArrayElementSaxParser(this.configuration));
        this.registerElementSaxParser(new IncludeElementSaxParser(this.configuration));
        this.registerElementSaxParser(new VirtualObjectElementSaxParser(this.configuration));
        this.registerElementSaxParser(new UnixTimestampPropertyElementSaxParser(this.configuration));
        this.registerElementSaxParser(new BooleanPropertyElementSaxParser(this.configuration));
        this.registerElementSaxParser(new ExtendPortElementSaxParser(this.configuration));
        this.registerElementSaxParser(new IgnorePropertyElementSaxParser(this.configuration));
        this.registerElementSaxParser(new PrototypeElementSaxParser(this.configuration));
        this.registerElementSaxParser(new IfElementSaxParser(this.configuration));
        this.registerElementSaxParser(new ElseElementSaxParser(this.configuration));
        this.registerElementSaxParser(new RelevanceElementParser(this.configuration));
        this.registerElementSaxParser(new LinkElementSaxParser(this.configuration));
        this.registerElementSaxParser(new TemplateElementSaxParser(this.configuration));
        this.registerElementSaxParser(new TemplatePackageElementSaxParser(this.configuration));
    }

    private void registerElementSaxParser(ElementSaxParser parser) {
        this.elementSaxParserChain.add(parser);
    }

    @Override
    public void startDocument() throws SAXException {
        this.parseContext.getStack().clear();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        for (ElementSaxParser parser : this.elementSaxParserChain) {
            if (!parser.qName().equals(qName)) continue;
            parser.handleAtStartElement(this.parseContext, attributes);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        for (ElementSaxParser parser : this.elementSaxParserChain) {
            if (!parser.qName().equals(qName)) continue;
            parser.handleAtEndElement(this.parseContext);
        }
    }
}

