/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.xml;

import com.github.developframework.jsonview.core.JsonviewConfiguration;
import com.github.developframework.jsonview.core.exception.JsonviewParseXmlException;
import com.github.developframework.jsonview.core.xml.ConfigurationSaxParseHandler;
import com.github.developframework.jsonview.core.xml.ConfigurationSource;
import com.github.developframework.jsonview.core.xml.FileConfigurationSource;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.helpers.DefaultHandler;

public class JsonviewConfigurationSaxReader {
    private static final Logger log = LoggerFactory.getLogger(JsonviewConfigurationSaxReader.class);
    private Set<ConfigurationSource> sources;

    public JsonviewConfigurationSaxReader(String config) {
        this.sources = new HashSet<ConfigurationSource>(1);
        this.sources.add(new FileConfigurationSource(config));
    }

    public JsonviewConfigurationSaxReader(ConfigurationSource source) {
        this.sources = new HashSet<ConfigurationSource>(1);
        this.sources.add(source);
    }

    public JsonviewConfigurationSaxReader(Set<ConfigurationSource> sources) {
        this.sources = sources;
    }

    public JsonviewConfiguration readConfiguration() {
        JsonviewConfiguration jsonviewConfiguration = new JsonviewConfiguration();
        ConfigurationSaxParseHandler handler = new ConfigurationSaxParseHandler(jsonviewConfiguration);
        for (ConfigurationSource source : this.sources) {
            this.handleSingleSource(handler, source);
            log.info("Jsonview framework loaded the configuration file \"{}\".", (Object)source.getSourceName());
        }
        return jsonviewConfiguration;
    }

    private void handleSingleSource(ConfigurationSaxParseHandler handler, ConfigurationSource source) {
        try {
            InputStream is = source.getInputStream();
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(is, (DefaultHandler)handler);
            is.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new JsonviewParseXmlException("Jsonview Framework parse source \"%s\" happened error: %s", source.getSourceName(), e.getMessage());
        }
    }

    public Set<ConfigurationSource> getSources() {
        return this.sources;
    }
}

