/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.jsonview.core.xml;

import com.github.developframework.jsonview.core.JsonviewConfiguration;
import com.github.developframework.jsonview.core.data.DataDefinition;
import com.github.developframework.jsonview.core.element.JsonviewTemplate;
import com.github.developframework.jsonview.core.xml.ContainerElementSaxParser;
import com.github.developframework.jsonview.core.xml.ParseContext;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;

class TemplateElementSaxParser
extends ContainerElementSaxParser<JsonviewTemplate> {
    TemplateElementSaxParser(JsonviewConfiguration jsonviewConfiguration) {
        super(jsonviewConfiguration);
    }

    @Override
    public String qName() {
        return "template";
    }

    @Override
    public void handleAtStartElement(ParseContext parseContext, Attributes attributes) {
        String id = attributes.getValue("id").trim();
        String data = attributes.getValue("data");
        String extend = attributes.getValue("extend");
        String mapFunctionValue = attributes.getValue("map-function");
        JsonviewTemplate jsonviewTemplate = new JsonviewTemplate(this.jsonviewConfiguration, parseContext.getCurrentTemplatePackage().getNamespace(), id);
        if (StringUtils.isNotBlank((CharSequence)data)) {
            jsonviewTemplate.setDataDefinition(new DataDefinition(data));
        } else {
            jsonviewTemplate.setDataDefinition(DataDefinition.EMPTY_DATA_DEFINITION);
        }
        if (StringUtils.isNotBlank((CharSequence)extend)) {
            String defaultNamespace = parseContext.getCurrentTemplatePackage().getNamespace();
            JsonviewTemplate jsonviewTemplate2 = jsonviewTemplate;
            jsonviewTemplate2.getClass();
            jsonviewTemplate.setExtend(jsonviewTemplate2.new JsonviewTemplate.Extend(extend.trim(), defaultNamespace));
        }
        if (StringUtils.isNotBlank((CharSequence)mapFunctionValue)) {
            jsonviewTemplate.setMapFunctionValue(mapFunctionValue);
        }
        jsonviewTemplate.setForClass(attributes.getValue("for-class"));
        parseContext.setCurrentTemplate(jsonviewTemplate);
        parseContext.getStack().push(jsonviewTemplate);
    }

    @Override
    public void handleAtEndElement(ParseContext parseContext) {
        JsonviewTemplate jsonviewTemplate = (JsonviewTemplate)parseContext.getStack().pop();
        jsonviewTemplate.loadForClassAllProperty();
        parseContext.getCurrentTemplatePackage().push(jsonviewTemplate);
    }

    @Override
    protected JsonviewTemplate createElementInstance(ParseContext parseContext, DataDefinition dataDefinition, String alias) {
        return null;
    }

    @Override
    protected void addOtherAttributes(JsonviewTemplate element, Attributes attributes) {
    }
}

