/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core;

import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.XmlProducer;
import com.github.developframework.kite.core.data.DataDefinition;
import com.github.developframework.kite.core.data.DataModel;
import com.github.developframework.kite.core.element.ArrayKiteElement;
import com.github.developframework.kite.core.element.Template;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.processor.xml.ArrayTemplateXmlProcessor;
import com.github.developframework.kite.core.processor.xml.TemplateXmlProcessor;
import com.github.developframework.kite.core.processor.xml.XmlProcessContext;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

class DefaultXmlProducer
implements XmlProducer {
    private KiteConfiguration kiteConfiguration;

    DefaultXmlProducer(KiteConfiguration kiteConfiguration) {
        this.kiteConfiguration = kiteConfiguration;
    }

    @Override
    public String produce(DataModel dataModel, String namespace, String templateId) {
        return this.produce(dataModel, namespace, templateId, false);
    }

    @Override
    public String produce(DataModel dataModel, String namespace, String templateId, boolean isPretty) {
        Document document = this.constructDocument(dataModel, namespace, templateId);
        try {
            OutputFormat format = new OutputFormat();
            format.setIndent(isPretty);
            format.setNewlines(isPretty);
            format.setSuppressDeclaration(this.kiteConfiguration.isXmlSuppressDeclaration());
            StringWriter writer = new StringWriter();
            XMLWriter xmlWriter = new XMLWriter((Writer)writer, format);
            xmlWriter.write(document);
            xmlWriter.close();
            return ((Object)writer).toString();
        }
        catch (IOException e) {
            throw new KiteException("produce xml string failed.");
        }
    }

    @Override
    public void outputXml(Writer writer, DataModel dataModel, String namespace, String templateId, boolean isPretty) {
        Document document = this.constructDocument(dataModel, namespace, templateId);
        try {
            OutputFormat format = new OutputFormat();
            format.setIndent(isPretty);
            format.setNewlines(isPretty);
            format.setSuppressDeclaration(this.kiteConfiguration.isXmlSuppressDeclaration());
            XMLWriter xmlWriter = new XMLWriter(writer, format);
            xmlWriter.write(document);
            xmlWriter.close();
        }
        catch (IOException e) {
            throw new KiteException("produce xml string failed.");
        }
    }

    private Document constructDocument(DataModel dataModel, String namespace, String templateId) {
        Template template = this.kiteConfiguration.extractTemplate(namespace, templateId);
        XmlProcessContext xmlProcessContext = new XmlProcessContext();
        xmlProcessContext.setDataModel(dataModel);
        xmlProcessContext.setConfiguration(this.kiteConfiguration);
        DataDefinition templateDataDefinition = template.getDataDefinition();
        if (templateDataDefinition != null) {
            Optional<Object> rootObjectOptional = dataModel.getData(templateDataDefinition.getExpression());
            if (rootObjectOptional.isPresent()) {
                Object rootObject = rootObjectOptional.get();
                if (rootObject.getClass().isArray() || rootObject instanceof List) {
                    return this.constructRootArrayNodeTree(xmlProcessContext, template, rootObject);
                }
                return this.constructRootObjectNodeTree(xmlProcessContext, template, rootObject);
            }
            throw new KiteException("Root data must not null.");
        }
        return this.constructRootObjectNodeTree(xmlProcessContext, template, null);
    }

    private Document constructRootObjectNodeTree(XmlProcessContext xmlProcessContext, Template template, Object value) {
        Element objNode;
        Document document = DocumentHelper.createDocument();
        String xmlRootName = template.getXmlRootName();
        String objNodeName = this.kiteConfiguration.getForXmlStrategy().propertyShowName(this.kiteConfiguration, template.getDataDefinition().getExpression().toString());
        if (StringUtils.isBlank((CharSequence)xmlRootName)) {
            objNode = document.addElement(objNodeName);
        } else {
            Element rootNode = document.addElement(xmlRootName);
            objNode = rootNode.addElement(objNodeName);
        }
        TemplateXmlProcessor templateProcessor = new TemplateXmlProcessor(xmlProcessContext, template, template.getDataDefinition().getExpression());
        templateProcessor.setValue(value);
        templateProcessor.setNode(objNode);
        templateProcessor.process(null);
        return document;
    }

    private Document constructRootArrayNodeTree(XmlProcessContext xmlProcessContext, Template template, Object value) {
        Element arrayNode;
        Document document = DocumentHelper.createDocument();
        String xmlRootName = template.getXmlRootName();
        String arrayNodeName = this.kiteConfiguration.getForXmlStrategy().propertyShowName(this.kiteConfiguration, template.getDataDefinition().getExpression().toString());
        if (StringUtils.isBlank((CharSequence)xmlRootName)) {
            arrayNode = document.addElement(arrayNodeName);
        } else {
            Element rootNode = document.addElement(xmlRootName);
            arrayNode = rootNode.addElement(arrayNodeName);
        }
        ArrayKiteElement arrayElement = new ArrayKiteElement(this.kiteConfiguration, template.getNamespace(), template.getTemplateId(), template.getDataDefinition(), null);
        arrayElement.setXmlItemName(template.getXmlItemName());
        arrayElement.setMapFunctionValue(template.getMapFunctionValue());
        ArrayTemplateXmlProcessor arrayProcessor = new ArrayTemplateXmlProcessor(xmlProcessContext, template, arrayElement);
        arrayProcessor.setValue(value);
        arrayProcessor.setNode(arrayNode);
        arrayProcessor.process(null);
        return document;
    }
}

