/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.element;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.expression.Expression;
import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.data.DataDefinition;
import com.github.developframework.kite.core.element.ContainerKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.element.ObjectKiteElement;
import com.github.developframework.kite.core.exception.KiteException;
import com.github.developframework.kite.core.processor.json.ArrayJsonProcessor;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import com.github.developframework.kite.core.processor.json.JsonProcessor;
import com.github.developframework.kite.core.processor.xml.ArrayXmlProcessor;
import com.github.developframework.kite.core.processor.xml.XmlProcessContext;
import com.github.developframework.kite.core.processor.xml.XmlProcessor;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Node;

public class ArrayKiteElement
extends ContainerKiteElement {
    private ObjectKiteElement itemObjectElement;
    private String mapFunctionValue;
    private String xmlItemName;

    public ArrayKiteElement(KiteConfiguration configuration, String namespace, String templateId, DataDefinition dataDefinition, String alias) {
        super(configuration, namespace, templateId, dataDefinition, alias);
        this.itemObjectElement = new ObjectKiteElement(configuration, namespace, templateId, dataDefinition, alias);
    }

    @Override
    public JsonProcessor<? extends KiteElement, ? extends JsonNode> createJsonProcessor(JsonProcessContext context, ObjectNode parentNode, Expression parentExpression) {
        return new ArrayJsonProcessor(context, this, JsonProcessor.childExpression(this, parentExpression));
    }

    @Override
    public XmlProcessor<? extends KiteElement, ? extends Node> createXmlProcessor(XmlProcessContext context, Node parentNode, Expression parentExpression) {
        return new ArrayXmlProcessor(context, this, XmlProcessor.childExpression(this, parentExpression));
    }

    @Override
    public void addChildElement(KiteElement element) {
        super.addChildElement(element);
        this.itemObjectElement.addChildElement(element);
    }

    @Override
    public void copyChildElement(ContainerKiteElement otherContainerElement) {
        super.copyChildElement(otherContainerElement);
        this.itemObjectElement.copyChildElement(otherContainerElement);
    }

    public Optional<String> getMapFunctionValueOptional() {
        return Optional.ofNullable(this.mapFunctionValue);
    }

    public String getXmlItemName() {
        if (StringUtils.isBlank((CharSequence)this.xmlItemName)) {
            throw new KiteException("\"xml-item\" is undefined in template \"%s : %s\".", this.namespace, this.templateId);
        }
        return this.xmlItemName;
    }

    public ObjectKiteElement getItemObjectElement() {
        return this.itemObjectElement;
    }

    public void setMapFunctionValue(String mapFunctionValue) {
        this.mapFunctionValue = mapFunctionValue;
    }

    public void setXmlItemName(String xmlItemName) {
        this.xmlItemName = xmlItemName;
    }
}

