/*
 * Decompiled with CFR 0.152.
 */
package com.github.developframework.kite.core.element;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.developframework.expression.Expression;
import com.github.developframework.kite.core.KiteConfiguration;
import com.github.developframework.kite.core.data.DataDefinition;
import com.github.developframework.kite.core.element.ArrayKiteElement;
import com.github.developframework.kite.core.element.KiteElement;
import com.github.developframework.kite.core.processor.json.JsonProcessContext;
import com.github.developframework.kite.core.processor.json.JsonProcessor;
import com.github.developframework.kite.core.processor.json.RelevanceJsonProcessor;
import com.github.developframework.kite.core.processor.xml.RelevanceXmlProcessor;
import com.github.developframework.kite.core.processor.xml.XmlProcessContext;
import com.github.developframework.kite.core.processor.xml.XmlProcessor;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Node;

public class RelevanceKiteElement
extends ArrayKiteElement {
    private String relFunctionValue;
    private RelevanceType relevanceType;

    public RelevanceKiteElement(KiteConfiguration configuration, String namespace, String templateId, DataDefinition dataDefinition, String alias) {
        super(configuration, namespace, templateId, dataDefinition, alias);
    }

    @Override
    public JsonProcessor<? extends KiteElement, ? extends JsonNode> createJsonProcessor(JsonProcessContext context, ObjectNode parentNode, Expression parentExpression) {
        return new RelevanceJsonProcessor(context, this, parentExpression);
    }

    @Override
    public XmlProcessor<? extends KiteElement, ? extends Node> createXmlProcessor(XmlProcessContext context, Node parentNode, Expression parentExpression) {
        return new RelevanceXmlProcessor(context, this, parentExpression);
    }

    public void setRelevanceType(String relevanceTypeValue) {
        this.relevanceType = StringUtils.isNotBlank((CharSequence)relevanceTypeValue) ? RelevanceType.valueOf(relevanceTypeValue.toUpperCase()) : RelevanceType.AUTO;
    }

    public String getRelFunctionValue() {
        return this.relFunctionValue;
    }

    public RelevanceType getRelevanceType() {
        return this.relevanceType;
    }

    public void setRelFunctionValue(String relFunctionValue) {
        this.relFunctionValue = relFunctionValue;
    }

    public static enum RelevanceType {
        AUTO,
        SINGLE,
        MULTIPLE;

    }
}

